/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.enums.items.EnumFossils;
import com.pixelmonmod.pixelmon.items.CoveredFossilItem;
import com.pixelmonmod.pixelmon.items.FossilItem;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.eventbus.api.Event;

public class RedeemFossilCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"restorefossil", "fossil"});

    public RedeemFossilCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "redeemfossil", "/redeemfossil [all]", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        Item itemInOffHand;
        ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(sender);
        ItemStack held = player.func_184586_b(Hand.MAIN_HAND);
        if (held.func_190926_b() || held.func_77973_b().equals(Items.field_190931_a)) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
            return;
        }
        ItemStack heldOffHand = player.func_184586_b(Hand.OFF_HAND);
        Item itemInHand = held.func_77973_b();
        Species species = this.getFossilSpecies(sender, itemInHand, itemInOffHand = heldOffHand.func_77973_b());
        if (species == null) {
            return;
        }
        boolean isGen8Fossil = species.getGeneration() == 8;
        int decreaseCount = 1;
        if (args.length > 0 && args[0].equalsIgnoreCase("all")) {
            decreaseCount = isGen8Fossil ? Math.min(held.func_190916_E(), heldOffHand.func_190916_E()) : held.func_190916_E();
        }
        int finalDecreaseCount = decreaseCount;
        PlayerPartyStorage pps = StorageProxy.getParty(player);
        PixelmonCommandUtils.THREAD_POOL.submit(() -> {
            for (int i = 0; i < finalDecreaseCount; ++i) {
                Pokemon pokemon = PokemonFactory.create(species);
                pokemon.setLevel(1);
                pokemon.setBall(PokeBallRegistry.POKE_BALL.getValueUnsafe());
                pps.add(pokemon);
                Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent(player, pokemon, "Fossil"));
            }
        });
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.redeemfossil.recoveredall", held.func_190916_E(), species.getLocalizedName()), false);
        held.func_190918_g(decreaseCount);
        if (isGen8Fossil) {
            heldOffHand.func_190918_g(decreaseCount);
        }
    }

    private Species getFossilSpecies(CommandSource sender, Item itemInHand, Item itemInOffHand) {
        if (itemInHand instanceof FossilItem) {
            FossilItem fossil = (FossilItem)itemInHand;
            if (fossil.getFossil().getGeneration() == 8) {
                if (itemInOffHand instanceof FossilItem) {
                    FossilItem fossil2 = (FossilItem)itemInOffHand;
                    return this.getGen8FossilSpecies(fossil.getFossil(), fossil2.getFossil());
                }
                sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.redeemfossil.emptyoffhand", new Object[0]), false);
                return null;
            }
            return fossil.getFossil().getPokemon();
        }
        if (itemInHand instanceof CoveredFossilItem) {
            CoveredFossilItem fossil = (CoveredFossilItem)itemInHand;
            if (fossil.getFossil().getGeneration() == 8) {
                if (itemInOffHand instanceof CoveredFossilItem) {
                    CoveredFossilItem fossil2 = (CoveredFossilItem)itemInOffHand;
                    return this.getGen8FossilSpecies(fossil.getFossil(), fossil2.getFossil());
                }
                sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.redeemfossil.emptyoffhand", new Object[0]), false);
                return null;
            }
            return fossil.getFossil().getPokemon();
        }
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.redeemfossil.notfossil", new Object[0]), false);
        return null;
    }

    private Species getGen8FossilSpecies(EnumFossils fossil1, EnumFossils fossil2) {
        if (fossil1.equals((Object)EnumFossils.BIRD) && fossil2.equals((Object)EnumFossils.DRAKE) || fossil1.equals((Object)EnumFossils.DRAKE) && fossil2.equals((Object)EnumFossils.BIRD)) {
            return PixelmonSpecies.DRACOZOLT.getValueUnsafe();
        }
        if (fossil1.equals((Object)EnumFossils.BIRD) && fossil2.equals((Object)EnumFossils.DINO) || fossil1.equals((Object)EnumFossils.DINO) && fossil2.equals((Object)EnumFossils.BIRD)) {
            return PixelmonSpecies.ARCTOZOLT.getValueUnsafe();
        }
        if (fossil1.equals((Object)EnumFossils.FISH) && fossil2.equals((Object)EnumFossils.DRAKE) || fossil1.equals((Object)EnumFossils.DRAKE) && fossil2.equals((Object)EnumFossils.FISH)) {
            return PixelmonSpecies.DRACOVISH.getValueUnsafe();
        }
        if (fossil1.equals((Object)EnumFossils.FISH) && fossil2.equals((Object)EnumFossils.DINO) || fossil1.equals((Object)EnumFossils.DINO) && fossil2.equals((Object)EnumFossils.FISH)) {
            return PixelmonSpecies.ARCTOVISH.getValueUnsafe();
        }
        return null;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, @Nullable BlockPos targetPos) throws CommandSyntaxException {
        if (args.length <= 1) {
            return Collections.singletonList("all");
        }
        return super.getTabCompletions(server, sender, args, targetPos);
    }
}

