/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;

public class PokeBombCommand
extends PixelCommand {
    public PokeBombCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "pokebomb", "/pokebomb <specs...>", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        if (args.length == 0) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerWorld world = sender.func_197023_e();
        PokemonSpecification spec = PokemonSpecificationProxy.create(args);
        for (Entity entity : world.getEntities().collect(Collectors.toList())) {
            PixelmonEntity pixelmon;
            if (!(entity instanceof PixelmonEntity) || (pixelmon = (PixelmonEntity)entity).hasOwner() || pixelmon.battleController != null) continue;
            spec.apply(pixelmon);
            pixelmon.getPokemon().initialize(new InitializeCategory[0]);
            pixelmon.resetAI();
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length >= 1) {
            return PixelmonCommandUtils.SPEC_REQUIREMENTS;
        }
        return Collections.emptyList();
    }
}

