/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public class LearnMoveCommand
extends PixelCommand {
    public LearnMoveCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "learnmove", "/learnmove [player] <slot> <move>", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if ((args = this.setupTargetOrSourceAsTarget(sender, args, 0)).length < 3) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayerEntity target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        int slot = PixelmonCommandUtils.requireInt(args[1], 1, 6, "pixelmon.command.invalidslot", args[1]);
        Pokemon pokemon = PixelmonCommandUtils.require(storage.get(slot - 1), "pixelmon.command.partyslot.nothing", target.func_200200_C_().getString());
        if (pokemon.isEgg()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.learnmove.egg", new Object[0]);
        }
        String attackName = StringUtils.join((Object[])args, (String)" ", (int)2, (int)args.length);
        attackName = attackName.replace('_', ' ');
        ImmutableAttack attack = (ImmutableAttack)((Object)PixelmonCommandUtils.require(AttackRegistry.getAttackBase(attackName), "pixelmon.command.learnmove.nonexistentmove", new Object[]{attackName}));
        if (!pokemon.getForm().getMoves().canLearn(attack)) {
            PixelmonCommandUtils.endCommand("pixelmon.command.learnmove.cannotlearn", pokemon.getLocalizedName(), attack.getAttackName());
        }
        if (pokemon.getMoveset().hasAttack(attack)) {
            PixelmonCommandUtils.endCommand("pixelmon.command.learnmove.alreadylearned", pokemon.getLocalizedName());
        }
        storage.retrieveAll("Command");
        if (pokemon.getMoveset().size() >= 4) {
            LearnMoveController.sendLearnMove(target, pokemon.getUUID(), attack);
        } else {
            pokemon.getMoveset().add(new Attack(attack));
        }
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.learnmove.success", target.func_145748_c_().getString(), pokemon.getLocalizedName()), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        boolean hasPermissionOtherTarget = this.hasPermissionOtherTarget(sender);
        switch (args.length) {
            case 1: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
            case 2: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.PARTY_SLOTS;
                }
                return new ArrayList<String>(AttackRegistry.getAllAttackNames());
            }
            case 3: {
                if (!hasPermissionOtherTarget) break;
                return new ArrayList<String>(AttackRegistry.getAllAttackNames());
            }
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

