/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.log.BattleLog;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class BattleLogCommand
extends PixelCommand {
    public BattleLogCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "battlelog", "/battlelog [player]", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        if (args.length < 1) {
            if (!(sender.func_197022_f() instanceof ServerPlayerEntity)) {
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.battlelog.not.player", new Object[0]);
                return;
            }
            BattleController battle = BattleRegistry.getBattle((PlayerEntity)sender.func_197022_f());
            if (battle == null) {
                PlayerPartyStorage party = StorageProxy.getParty((ServerPlayerEntity)sender.func_197022_f());
                if (party.getLastBattle() == null) {
                    PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.battlelog.not.battling", new Object[0]);
                    return;
                }
                this.sendLog(sender, party.getLastBattle());
                return;
            }
            this.sendLog(sender, battle.battleLog);
            return;
        }
        ServerPlayerEntity target = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(args[0]);
        if (target == null) {
            PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.battlelog.player.not.found", new Object[0]);
            return;
        }
        BattleController battle = BattleRegistry.getBattle((PlayerEntity)target);
        if (battle == null) {
            PlayerPartyStorage party = StorageProxy.getParty(target);
            if (party.getLastBattle() == null) {
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.battlelog.not.battling", new Object[0]);
                return;
            }
            this.sendLog(sender, party.getLastBattle());
            return;
        }
        this.sendLog(sender, battle.battleLog);
    }

    private void sendLog(CommandSource sender, BattleLog log) {
        try {
            log.exportLogFile(null, null).whenComplete((file, throwable) -> PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.battlelog.logged", iFormattableTextComponent -> iFormattableTextComponent.func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath()))), new Object[0]));
        }
        catch (Exception e) {
            PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.battlelog.failed", new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        return PixelmonCommandUtils.tabCompleteUsernames();
    }
}

