/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.trading;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetClientTradePairPacket
extends AbstractPixelmonPacket {
    private TradePair tradePair;
    private boolean hasPokemon = false;

    public SetClientTradePairPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public SetClientTradePairPacket(TradePair tradePair, boolean hasPokemon) {
        super(PacketDirection.PLAY_CLIENT);
        this.tradePair = tradePair;
        this.hasPokemon = hasPokemon;
    }

    @Override
    public void decode(PacketBuffer buf) {
        PokemonSpecification offer = PokemonSpecificationProxy.fromNbt(buf.func_150793_b());
        PokemonSpecification exchange = PokemonSpecificationProxy.fromNbt(buf.func_150793_b());
        String description = buf.func_218666_n();
        if (description.equals("null")) {
            description = null;
        }
        this.tradePair = new TradePair(offer, exchange, description);
        this.hasPokemon = buf.readBoolean();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_150786_a(this.tradePair.offer.write(new CompoundNBT()));
        buf.func_150786_a(this.tradePair.exchange.write(new CompoundNBT()));
        buf.func_180714_a(this.tradePair.description == null || this.tradePair.description.isEmpty() ? "null" : this.tradePair.description);
        buf.writeBoolean(this.hasPokemon);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ClientProxy.currentTradePair = this.tradePair;
        ClientProxy.playerHasTradeRequestPokemon = this.hasPokemon;
    }
}

