/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.sync;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SyncMovesPacket
extends AbstractPixelmonPacket {
    private List<ImmutableAttack> moves;

    public SyncMovesPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    private SyncMovesPacket(List<ImmutableAttack> moves) {
        this();
        this.moves = moves;
    }

    public static void sync(ServerPlayerEntity player) {
        List<ImmutableAttack> moves = AttackRegistry.getAllAttacks();
        int groups = Math.max(1, moves.size() / 100);
        int size = moves.size() / groups;
        for (int group = 0; group < groups; ++group) {
            int i;
            ArrayList sublist = Lists.newArrayList();
            if (group + 1 == groups) {
                for (i = size * group; i < moves.size(); ++i) {
                    sublist.add(moves.get(i));
                }
            } else {
                for (i = size * group; i < size * (group + 1); ++i) {
                    sublist.add(moves.get(i));
                }
            }
            NetworkHelper.sendPacket(player, new SyncMovesPacket(sublist));
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.moves = Lists.newArrayList();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            String json = buffer.func_218666_n();
            ImmutableAttack attack = (ImmutableAttack)AttackRegistry.GSON.fromJson(json, ImmutableAttack.class);
            attack.setJson(json);
            attack.setResourceLocation(buffer.func_192575_l());
            this.moves.add(attack);
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.moves.size());
        for (ImmutableAttack attack : this.moves) {
            buffer.func_180714_a(attack.getJson());
            buffer.func_192572_a(attack.getResourceLocation());
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        for (ImmutableAttack attack : this.moves) {
            AttackRegistry.addAttack(attack, attack.getResourceLocation(), attack.getJson());
        }
        CommonProxy.loadDefaultMoveSkills();
        ClientProxy.moveSkills.clear();
        ClientProxy.moveSkills.addAll(MoveSkill.moveSkills);
    }
}

