/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.selection;

import com.pixelmonmod.pixelmon.client.gui.custom.selection.SelectionScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenSelectionPacket
extends AbstractPixelmonPacket {
    private ITextComponent title;
    private ITextComponent text;
    private int selections;
    private boolean allowExit;

    public OpenSelectionPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public OpenSelectionPacket(ITextComponent title, ITextComponent text, int selections, boolean allowExit) {
        this();
        this.title = title;
        this.text = text;
        this.selections = selections;
        this.allowExit = allowExit;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.title = buf.func_179258_d();
        this.text = buf.func_179258_d();
        this.selections = buf.readInt();
        this.allowExit = buf.readBoolean();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179256_a(this.title);
        buf.func_179256_a(this.text);
        buf.writeInt(this.selections);
        buf.writeBoolean(this.allowExit);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        this.onClient(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClient(NetworkEvent.Context context) {
        Minecraft.func_71410_x().func_147108_a((Screen)new SelectionScreen(this.title, this.text, this.selections, this.allowExit));
    }
}

