/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.client.gui.npcEditor.ChattingNPCEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.QuestGiverNPCEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.ShopkeeperEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TrainerEditorScreen;
import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetNPCEditDataPacket
extends AbstractPixelmonPacket {
    private SetTrainerData data;
    private EnumNPCType npcType;
    private ArrayList<String> chatPages;
    private String name;
    private String json;
    private String texture;

    public SetNPCEditDataPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public SetNPCEditDataPacket(SetTrainerData data) {
        super(PacketDirection.PLAY_CLIENT);
        this.npcType = EnumNPCType.Trainer;
        this.data = data;
    }

    public SetNPCEditDataPacket(String name, ArrayList<String> chatPages) {
        this(name, chatPages, EnumNPCType.ChattingNPC);
    }

    public SetNPCEditDataPacket(String name, ArrayList<String> chatPages, EnumNPCType type) {
        super(PacketDirection.PLAY_CLIENT);
        this.name = name;
        this.npcType = type;
        this.chatPages = chatPages;
    }

    public SetNPCEditDataPacket(String json, String name, String texture) {
        super(PacketDirection.PLAY_CLIENT);
        this.json = json;
        this.name = name;
        this.texture = texture;
        this.npcType = EnumNPCType.Shopkeeper;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeShort(this.npcType.ordinal());
        switch (this.npcType) {
            case Trainer: {
                this.data.encodeInto(buffer);
                break;
            }
            case ChattingNPC: 
            case QuestGiver: {
                buffer.func_180714_a(this.name);
                buffer.writeShort(this.chatPages.size());
                for (String page : this.chatPages) {
                    buffer.func_180714_a(page);
                }
                break;
            }
            case Shopkeeper: {
                buffer.func_180714_a(this.name);
                buffer.func_180714_a(this.json);
                buffer.func_180714_a(this.texture);
                break;
            }
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.npcType = EnumNPCType.getFromOrdinal(buffer.readShort());
        switch (this.npcType) {
            case Trainer: {
                this.data = new SetTrainerData();
                this.data.decodeInto(buffer);
                break;
            }
            case ChattingNPC: 
            case QuestGiver: {
                this.name = buffer.func_218666_n();
                this.chatPages = new ArrayList();
                int numPages = buffer.readShort();
                for (int i = 0; i < numPages; ++i) {
                    this.chatPages.add(buffer.func_218666_n());
                }
                break;
            }
            case Shopkeeper: {
                this.name = buffer.func_218666_n();
                this.json = buffer.func_218666_n();
                this.texture = buffer.func_218666_n();
                break;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        switch (this.npcType) {
            case Trainer: {
                TrainerEditorScreen.trainerData = this.data;
                break;
            }
            case ChattingNPC: {
                ChattingNPCEditorScreen.name = this.name;
                ChattingNPCEditorScreen.chatPages = this.chatPages;
                ChattingNPCEditorScreen.chatChanged = true;
                break;
            }
            case QuestGiver: {
                QuestGiverNPCEditorScreen.name = this.name;
                QuestGiverNPCEditorScreen.chatPages = this.chatPages;
                QuestGiverNPCEditorScreen.chatChanged = true;
                break;
            }
            case Shopkeeper: {
                context.enqueueWork(() -> {
                    ShopkeeperEditorScreen.json = this.json;
                    ShopkeeperEditorScreen.name = this.name;
                    if (Minecraft.func_71410_x().field_71462_r instanceof ShopkeeperEditorScreen) {
                        ((ShopkeeperEditorScreen)Minecraft.func_71410_x().field_71462_r).updateShopkeeper(this.texture);
                    }
                });
                break;
            }
        }
    }
}

