/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class StartBattlePacket
extends AbstractPixelmonPacket {
    private int battleIndex;
    private ParticipantType[][] type;
    private int afkActivate;
    private int afkTurn;
    int catchCombo;
    private BattleRules rules;

    public StartBattlePacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public StartBattlePacket(int battleIndex, ParticipantType[][] type, BattleRules rules) {
        this(battleIndex, type, -1, -1, 0, rules);
    }

    public StartBattlePacket(int battleIndex, ParticipantType[][] type, int afkActivate, int afkTurn, int catchCombo, BattleRules rules) {
        this();
        this.battleIndex = battleIndex;
        this.type = type;
        this.afkActivate = afkActivate;
        this.afkTurn = afkTurn;
        this.catchCombo = catchCombo;
        this.rules = rules;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.battleIndex);
        for (int i = 0; i < 2; ++i) {
            buffer.writeShort(this.type[i].length);
            for (ParticipantType p : this.type[i]) {
                buffer.writeInt(p.ordinal());
            }
        }
        buffer.writeInt(this.afkActivate);
        buffer.writeInt(this.afkTurn);
        buffer.writeInt(this.catchCombo);
        this.rules.encodeInto(buffer);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.battleIndex = buffer.readInt();
        this.type = new ParticipantType[2][];
        for (int i = 0; i < 2; ++i) {
            this.type[i] = new ParticipantType[buffer.readShort()];
            for (int j = 0; j < this.type[i].length; ++j) {
                this.type[i][j] = ParticipantType.get(buffer.readInt());
            }
        }
        this.afkActivate = buffer.readInt();
        this.afkTurn = buffer.readInt();
        this.catchCombo = buffer.readInt();
        this.rules = new BattleRules();
        this.rules.decodeInto(buffer);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ClientProxy.battleManager.startBattle(this.battleIndex, this.type, this.afkActivate, this.afkTurn, this.rules);
        ClientProxy.battleManager.catchCombo = this.catchCombo;
    }
}

