/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BagSection;
import com.pixelmonmod.pixelmon.api.events.battles.BagItemEvent;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ReturnBagItemsPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RequestBagItemsPacket
extends AbstractPixelmonPacket {
    private BagSection section;

    public RequestBagItemsPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public RequestBagItemsPacket(BagSection section) {
        this();
        this.section = section;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.section.ordinal());
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.section = BagSection.values()[buffer.readInt()];
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        BattleController controller = BattleRegistry.getBattle((PlayerEntity)context.getSender());
        if (controller == null) {
            return;
        }
        BagItemEvent.CollectItems.Pre pre = new BagItemEvent.CollectItems.Pre(controller, "", context.getSender(), this.section);
        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
            return;
        }
        this.reply(context, new ReturnBagItemsPacket(pre.getSection(), pre.getItems()));
        Pixelmon.EVENT_BUS.post((Event)new BagItemEvent.CollectItems.Post(controller, "", context.getSender(), pre.getSection(), pre.getItems()));
    }
}

