/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RemoveSpectatorPacket
extends AbstractPixelmonPacket {
    private int battleControllerIndex;
    private UUID uuid;

    public RemoveSpectatorPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RemoveSpectatorPacket(int battleControllerIndex, UUID uuid) {
        super(PacketDirection.PLAY_SERVER, true);
        this.battleControllerIndex = battleControllerIndex;
        this.uuid = uuid;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.battleControllerIndex = buffer.readInt();
        this.uuid = new UUID(buffer.readLong(), buffer.readLong());
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.battleControllerIndex);
        buffer.writeLong(this.uuid.getMostSignificantBits());
        buffer.writeLong(this.uuid.getLeastSignificantBits());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        context.getSender().func_143004_u();
        BattleController bc = BattleRegistry.getBattle(this.battleControllerIndex);
        if (bc != null) {
            bc.removeSpectator(context.getSender());
        }
    }
}

