/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetAllBattlingPokemonPacket;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class EnforcedRevivePacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private int healthPercentage;

    public EnforcedRevivePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public EnforcedRevivePacket(UUID pokemonUUID, int healthPercentage) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pokemonUUID = pokemonUUID;
        this.healthPercentage = healthPercentage;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.pokemonUUID);
        buffer.writeInt(this.healthPercentage);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.healthPercentage = buffer.readInt();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        BattleController bc = BattleRegistry.getBattle((PlayerEntity)player);
        if (bc == null) {
            return;
        }
        PlayerParticipant playerParticipant = bc.getPlayer((PlayerEntity)player);
        UUID toBeRevivedPokemonUUID = this.pokemonUUID == null ? playerParticipant.getBattleAI().getFaintedPokemonToRevive() : this.pokemonUUID;
        PlayerPartyStorage party = StorageProxy.getParty(player);
        Pokemon pokemon = party.find(toBeRevivedPokemonUUID);
        if (pokemon != null && pokemon.isFainted()) {
            DelegateLink pokemonLink = new DelegateLink(pokemon);
            pokemon.setHealthPercentage(this.healthPercentage);
            ((PokemonLink)pokemonLink).setHealth(pokemon.getHealth());
            ((PokemonLink)pokemonLink).update(EnumUpdateType.HP);
            NetworkHelper.sendPacket(new SetAllBattlingPokemonPacket(PixelmonClientData.convertToGUI(Arrays.asList(playerParticipant.allPokemon)), false), player);
        }
        for (PixelmonWrapper pw : playerParticipant.getActiveUnfaintedPokemon()) {
            if (!pw.wait) continue;
            pw.wait = false;
        }
    }
}

