/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.badgecase;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.client.gui.badgecase.BadgeCaseScreen;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.enums.items.EnumBadgeCase;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenBadgeCasePacket
extends AbstractPixelmonPacket {
    private static final EnumUpdateType[] UPDATE_TYPES = new EnumUpdateType[]{EnumUpdateType.Nickname, EnumUpdateType.Name, EnumUpdateType.Form, EnumUpdateType.Egg};
    private String owner;
    private boolean allowChanges;
    private boolean custom;
    private EnumBadgeCase color;
    private List<ItemStack> badges;
    private Pokemon[] party = new Pokemon[6];

    public OpenBadgeCasePacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public OpenBadgeCasePacket(String owner, boolean allowChanges, boolean custom, EnumBadgeCase color, List<ItemStack> badges, List<Pokemon> pokemon) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.owner = owner;
        this.allowChanges = allowChanges;
        this.custom = custom;
        this.color = color;
        this.badges = badges;
        for (int i = 0; i < this.party.length; ++i) {
            if (pokemon.size() <= i) continue;
            this.party[i] = pokemon.get(i);
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        PacketBuffer buffer = new PacketBuffer((ByteBuf)buf);
        this.owner = buffer.func_150789_c(30);
        this.allowChanges = buffer.readBoolean();
        this.custom = buffer.readBoolean();
        this.color = EnumBadgeCase.fromIndex(buffer.readByte());
        for (int i = 0; i < this.party.length; ++i) {
            this.party[i] = buffer.readBoolean() ? PokemonFactory.create(UUID.randomUUID()).readFromByteBuffer(buffer, UPDATE_TYPES) : null;
        }
        this.badges = new ArrayList<ItemStack>();
        CompoundNBT superCompound = buffer.func_150793_b();
        ListNBT list = superCompound.func_150295_c("list", 10);
        for (INBT base : list) {
            ItemStack item = new ItemStack((IItemProvider)Item.func_150899_d((int)0));
            this.badges.add(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)base)));
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        PacketBuffer buffer = new PacketBuffer((ByteBuf)buf);
        buffer.func_180714_a(this.owner);
        buffer.writeBoolean(this.allowChanges);
        buffer.writeBoolean(this.custom);
        buffer.writeByte(this.color.ordinal());
        for (int i = 0; i < this.party.length; ++i) {
            buffer.writeBoolean(this.party[i] != null);
            if (this.party[i] == null) continue;
            this.party[i].writeToByteBuffer(buffer, UPDATE_TYPES);
        }
        CompoundNBT superCompound = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (ItemStack stack : this.badges) {
            list.add((Object)stack.func_77955_b(new CompoundNBT()));
        }
        superCompound.func_218657_a("list", (INBT)list);
        buffer.func_150786_a(superCompound);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        if (Minecraft.func_71410_x().field_71462_r instanceof BadgeCaseScreen) {
            ((BadgeCaseScreen)Minecraft.func_71410_x().field_71462_r).updateBadgeCase(this.owner, this.allowChanges, this.custom, this.color, this.badges, this.party);
        } else {
            Minecraft.func_71410_x().func_147108_a((Screen)new BadgeCaseScreen(this.owner, this.allowChanges, this.custom, this.color, this.badges, this.party));
        }
    }
}

