/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenScreenPacket
extends AbstractPixelmonPacket {
    private EnumGuiScreen gui;
    private int[] data;

    public OpenScreenPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    private OpenScreenPacket(EnumGuiScreen gui, int ... data) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.gui = gui;
        this.data = data;
    }

    public static void open(PlayerEntity player, EnumGuiScreen gui, int ... data) {
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71133_b.execute(() -> NetworkHelper.sendPacket(new OpenScreenPacket(gui, data), (ServerPlayerEntity)player));
        } else {
            OpenScreenPacket.openClient(player, gui, data);
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.gui = EnumGuiScreen.getFromOrdinal(buf.readByte());
        this.data = new int[buf.readByte()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = buf.readInt();
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeByte(this.gui.getIndex());
        buf.writeByte(this.data.length);
        for (int i : this.data) {
            buf.writeInt(i);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        OpenScreenPacket.openClient((PlayerEntity)Minecraft.func_71410_x().field_71439_g, this.gui, this.data);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openClient(PlayerEntity player, EnumGuiScreen gui, int[] data) {
        Screen screen = ClientProxy.createScreen(player, gui, data);
        Minecraft.func_71410_x().func_147108_a(screen);
    }
}

