/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.IFrameCounter;
import com.pixelmonmod.pixelmon.blocks.tileentity.ISpecialTexture;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class RenderTileEntityGenericSMD<T extends TileEntity>
extends TileEntityRenderer<T> {
    private GenericModelHolder<GenericSmdModel> holder;
    private ResourceLocation texture;
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(1.0f, 0.0f, 0.0f);
    private Vector3f translate = new Vector3f(0.0f, 0.0f, 0.0f);

    public RenderTileEntityGenericSMD(TileEntityRendererDispatcher dispatcher, GenericModelHolder<GenericSmdModel> modelHolder, ResourceLocation texture) {
        super(dispatcher);
        this.holder = modelHolder;
        this.texture = texture;
    }

    public RenderTileEntityGenericSMD(TileEntityRendererDispatcher dispatcher, ResourceLocation model, ResourceLocation texture) {
        this(dispatcher, new GenericModelHolder<GenericSmdModel>(model), texture);
    }

    public RenderTileEntityGenericSMD(TileEntityRendererDispatcher dispatcher, String pqcPath, String texture) {
        this(dispatcher, ResourceLocationHelper.of("pixelmon", "models/" + pqcPath.toLowerCase(Locale.ROOT)), texture == null ? null : ResourceLocationHelper.of("pixelmon:textures/block/" + texture.toLowerCase(Locale.ROOT)));
    }

    @Override
    protected int getRotation(BlockState state) {
        return 0;
    }

    protected int getRotationSelf(BlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof MultiBlock || block instanceof GenericRotatableModelBlock) {
            Direction facing;
            Direction direction = facing = block instanceof MultiBlock ? (Direction)state.func_177229_b((Property)MultiBlock.FACING) : (Direction)state.func_177229_b((Property)GenericRotatableModelBlock.FACING);
            if (facing == Direction.EAST) {
                return 90;
            }
            if (facing == Direction.NORTH) {
                return 0;
            }
            if (facing == Direction.WEST) {
                return 270;
            }
            if (facing == Direction.SOUTH) {
                return 180;
            }
        }
        return 0;
    }

    @Override
    public void render(T te, BlockState state, double x, double y, double z, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        ResourceLocation texture = te instanceof ISpecialTexture ? ((ISpecialTexture)te).getTexture() : this.texture;
        if (texture == null) {
            return;
        }
        IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(texture));
        GenericSmdModel model = (GenericSmdModel)((Object)this.holder.getModel());
        if (model.getModel() == null) {
            model.reloadModel();
        }
        if (te instanceof IFrameCounter) {
            model.setFrame(((IFrameCounter)te).getFrame());
        }
        matrix.func_227860_a_();
        matrix.func_227863_a_(QuaternionHelper.fromEuler(this.getRotationSelf(state), 0.0f, 1.0f, 0.0f));
        matrix.func_227863_a_(QuaternionHelper.fromEuler(this.angle, this.axis.func_195899_a(), this.axis.func_195900_b(), this.axis.func_195902_c()));
        matrix.func_227861_a_((double)this.translate.func_195899_a(), (double)this.translate.func_195900_b(), (double)this.translate.func_195902_c());
        matrix.func_227862_a_(model.getModel().getScale(), model.getModel().getScale(), model.getModel().getScale());
        model.getModel().animate();
        model.render(matrix, vertices, combinedLight, combinedOverlay);
        matrix.func_227865_b_();
    }

    public RenderTileEntityGenericSMD<T> enableBlend() {
        this.blend = true;
        return this;
    }

    public RenderTileEntityGenericSMD<T> disableCulling() {
        this.disableCulling = true;
        return this;
    }

    public RenderTileEntityGenericSMD<T> disableLighting() {
        this.disableLighting = true;
        return this;
    }

    public RenderTileEntityGenericSMD<T> setCorrectionAngles(int correctionAngles) {
        this.correctionAngles = correctionAngles;
        return this;
    }

    public RenderTileEntityGenericSMD<T> setYOffset(float yOffset) {
        this.yOffset = yOffset;
        return this;
    }

    public RenderTileEntityGenericSMD<T> rotate(float d, float axisX, float axisY, float axisZ) {
        this.angle = d;
        this.axis = new Vector3f(axisX, axisY, axisZ);
        return this;
    }

    public RenderTileEntityGenericSMD<T> translate(float x, float y, float z) {
        this.translate = new Vector3f(x, y, z);
        return this;
    }

    public RenderTileEntityGenericSMD<T> scale(float scale) {
        this.scale = scale;
        return this;
    }
}

