/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.ModelHolder;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PixelmonLayerRobe
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private static final ResourceLocation WIZARD_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/robe/wizard.png");
    private static final ResourceLocation HWEEN_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/robe/hween.png");
    private static final ResourceLocation ALTER_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/robe/alter.png");
    private static final ResourceLocation STRIKE_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/robe/strike.png");
    private static final ResourceLocation ASHEN_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/robe/ashen.png");
    private static final ResourceLocation ABOMASNOW_CLOAK_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/robe/abomasnow_cloak.png");
    private static final ResourceLocation FROSLASS_YUKATA_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/robe/yukata.png");
    private static final ModelHolder<GenericSmdModel> WIZARD_ROBE = new GenericModelHolder<GenericSmdModel>("playeritems/robe/robe.pqc");
    private static final ModelHolder<GenericSmdModel> WIZARD_ROBE_ARM = new GenericModelHolder<GenericSmdModel>("playeritems/robe/robe_arm.pqc");
    private static final ModelHolder<GenericSmdModel> HWEEN_ROBE = new GenericModelHolder<GenericSmdModel>("playeritems/robe/hween_robe.pqc");
    private static final ModelHolder<GenericSmdModel> HWEEN_ROBE_LEFT = new GenericModelHolder<GenericSmdModel>("playeritems/robe/hween_robe_left_arm.pqc");
    private static final ModelHolder<GenericSmdModel> HWEEN_ROBE_RIGHT = new GenericModelHolder<GenericSmdModel>("playeritems/robe/hween_robe_right_arm.pqc");
    private static final ModelHolder<GenericSmdModel> ABOMASNOW_CLOAK = new GenericModelHolder<GenericSmdModel>("playeritems/robe/abomasnow_cloak.pqc");
    private static final ModelHolder<GenericSmdModel> ABOMASNOW_CLOAK_ARM = new GenericModelHolder<GenericSmdModel>("playeritems/robe/abomasnow_cloak_arm.pqc");
    private static final ModelHolder<GenericSmdModel> YUKATA_ROBE = new GenericModelHolder<GenericSmdModel>("playeritems/robe/yukata.pqc");
    private static final ModelHolder<GenericSmdModel> YUKATA_LEFT_ARM = new GenericModelHolder<GenericSmdModel>("playeritems/robe/yukata_left_arm.pqc");
    private static final ModelHolder<GenericSmdModel> YUKATA_RIGHT_ARM = new GenericModelHolder<GenericSmdModel>("playeritems/robe/yukata_right_arm.pqc");
    private final PlayerRenderer renderer;
    ModelRenderer leftArm;
    ModelRenderer rightArm;

    public PixelmonLayerRobe(PlayerRenderer renderer) {
        super((IEntityRenderer)renderer);
        this.renderer = renderer;
    }

    public void render(MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        PixelExtrasData extras = PlayerExtraDataStore.get((PlayerEntity)player);
        if (!extras.isReady() || !extras.isEnabled(PixelExtrasData.Category.ROBE) || extras.getRobeType() == PixelExtrasData.RobeType.NONE || player.func_82150_aj()) {
            return;
        }
        int packedOverlay = LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f);
        PixelExtrasData.RobeType robeType = extras.getRobeType();
        this.leftArm = ((PlayerModel)this.renderer.func_217764_d()).field_178724_i;
        this.rightArm = ((PlayerModel)this.renderer.func_217764_d()).field_178723_h;
        ModelRenderer body = ((PlayerModel)this.renderer.func_217764_d()).field_78115_e;
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("layer_robe");
        matrix.func_227860_a_();
        body.func_228307_a_(matrix);
        matrix.func_227861_a_(0.0, (double)1.22f, 0.0);
        matrix.func_227862_a_(0.36f, 0.45f, 0.45f);
        IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(this.getTexture(robeType)));
        if (robeType == PixelExtrasData.RobeType.WIZARD || robeType == PixelExtrasData.RobeType.ALTER || robeType == PixelExtrasData.RobeType.STRIKE || robeType == PixelExtrasData.RobeType.ASHEN) {
            WIZARD_ROBE.getModel().getModel().animate();
            WIZARD_ROBE.getModel().render(matrix, vertices, packedLight, packedOverlay);
        } else if (robeType == PixelExtrasData.RobeType.DROWNED) {
            HWEEN_ROBE.getModel().getModel().animate();
            HWEEN_ROBE.getModel().render(matrix, vertices, packedLight, packedOverlay);
        } else if (robeType == PixelExtrasData.RobeType.WINTER_CLOAK) {
            ABOMASNOW_CLOAK.getModel().getModel().animate();
            ABOMASNOW_CLOAK.getModel().render(matrix, vertices, packedLight, packedOverlay);
        } else if (robeType == PixelExtrasData.RobeType.FROSLASS_YUKATA) {
            YUKATA_ROBE.getModel().getModel().animate();
            YUKATA_ROBE.getModel().render(matrix, vertices, packedLight, packedOverlay);
        }
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        this.renderArm(matrix, vertices, packedLight, packedOverlay, robeType, HandSide.RIGHT);
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        this.renderArm(matrix, vertices, packedLight, packedOverlay, robeType, HandSide.LEFT);
        matrix.func_227865_b_();
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }

    private ResourceLocation getTexture(PixelExtrasData.RobeType type) {
        if (type == PixelExtrasData.RobeType.WIZARD) {
            return WIZARD_TEXTURE;
        }
        if (type == PixelExtrasData.RobeType.DROWNED) {
            return HWEEN_TEXTURE;
        }
        if (type == PixelExtrasData.RobeType.ALTER) {
            return ALTER_TEXTURE;
        }
        if (type == PixelExtrasData.RobeType.STRIKE) {
            return STRIKE_TEXTURE;
        }
        if (type == PixelExtrasData.RobeType.ASHEN) {
            return ASHEN_TEXTURE;
        }
        if (type == PixelExtrasData.RobeType.FROSLASS_YUKATA) {
            return FROSLASS_YUKATA_TEXTURE;
        }
        if (type == PixelExtrasData.RobeType.WINTER_CLOAK) {
            return ABOMASNOW_CLOAK_TEXTURE;
        }
        return WIZARD_TEXTURE;
    }

    public void translateAndRotate(MatrixStack p_228307_1_, ModelRenderer renderer, float scale) {
        p_228307_1_.func_227861_a_((double)(renderer.field_78800_c / 16.0f), (double)(renderer.field_78797_d / 16.0f), (double)(renderer.field_78798_e / 16.0f));
        if (renderer.field_78808_h != 0.0f) {
            p_228307_1_.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(renderer.field_78808_h));
        }
        if (renderer.field_78796_g != 0.0f) {
            p_228307_1_.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(renderer.field_78796_g));
        }
        if (renderer.field_78795_f != 0.0f) {
            p_228307_1_.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(renderer.field_78795_f));
        }
    }

    private void renderArm(MatrixStack matrix, IVertexBuilder vertices, int light, int overlay, PixelExtrasData.RobeType type, HandSide arm) {
        if (type == PixelExtrasData.RobeType.WIZARD || type == PixelExtrasData.RobeType.ALTER || type == PixelExtrasData.RobeType.STRIKE || type == PixelExtrasData.RobeType.ASHEN) {
            if (arm == HandSide.RIGHT) {
                ((PlayerModel)this.renderer.func_217764_d()).func_225599_a_(HandSide.RIGHT, matrix);
                matrix.func_227862_a_(0.43f, 0.43f, 0.46f);
            } else {
                ((PlayerModel)this.renderer.func_217764_d()).func_225599_a_(HandSide.LEFT, matrix);
                matrix.func_227862_a_(0.43f, 0.43f, 0.46f);
                matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
            }
            PixelmonLayerRobe.WIZARD_ROBE_ARM.getModel().modelRenderer.offsetX = -0.2;
            WIZARD_ROBE_ARM.getModel().getModel().animate();
            WIZARD_ROBE_ARM.getModel().render(matrix, vertices, light, overlay);
        } else if (type == PixelExtrasData.RobeType.DROWNED) {
            if (arm == HandSide.RIGHT) {
                ((PlayerModel)this.renderer.func_217764_d()).func_225599_a_(HandSide.RIGHT, matrix);
                matrix.func_227862_a_(0.43f, 0.43f, 0.46f);
                matrix.func_227861_a_(0.1, 0.0, 0.0);
                matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
                HWEEN_ROBE_RIGHT.getModel().getModel().animate();
                HWEEN_ROBE_RIGHT.getModel().render(matrix, vertices, light, overlay);
            } else {
                ((PlayerModel)this.renderer.func_217764_d()).func_225599_a_(HandSide.LEFT, matrix);
                matrix.func_227862_a_(0.43f, 0.43f, 0.46f);
                matrix.func_227861_a_(-0.1, 0.0, 0.0);
                HWEEN_ROBE_LEFT.getModel().getModel().animate();
                HWEEN_ROBE_LEFT.getModel().render(matrix, vertices, light, overlay);
            }
        } else if (type == PixelExtrasData.RobeType.WINTER_CLOAK) {
            if (arm == HandSide.RIGHT) {
                ((PlayerModel)this.renderer.func_217764_d()).func_225599_a_(HandSide.RIGHT, matrix);
                matrix.func_227862_a_(0.43f, 0.43f, 0.46f);
                matrix.func_227861_a_(0.05, 0.06, 0.0);
                ABOMASNOW_CLOAK_ARM.getModel().getModel().animate();
                ABOMASNOW_CLOAK_ARM.getModel().render(matrix, vertices, light, overlay);
            } else {
                ((PlayerModel)this.renderer.func_217764_d()).func_225599_a_(HandSide.LEFT, matrix);
                matrix.func_227862_a_(0.43f, 0.43f, 0.46f);
                matrix.func_227861_a_(-0.09, 0.04, 0.0);
                matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
                ABOMASNOW_CLOAK_ARM.getModel().getModel().animate();
                ABOMASNOW_CLOAK_ARM.getModel().render(matrix, vertices, light, overlay);
            }
        } else if (type == PixelExtrasData.RobeType.FROSLASS_YUKATA) {
            if (arm == HandSide.RIGHT) {
                ((PlayerModel)this.renderer.func_217764_d()).func_225599_a_(HandSide.RIGHT, matrix);
                matrix.func_227862_a_(0.43f, 0.43f, 0.46f);
                matrix.func_227861_a_(0.05, 0.06, 0.0);
                YUKATA_RIGHT_ARM.getModel().getModel().animate();
                YUKATA_RIGHT_ARM.getModel().render(matrix, vertices, light, overlay);
            } else {
                ((PlayerModel)this.renderer.func_217764_d()).func_225599_a_(HandSide.LEFT, matrix);
                matrix.func_227862_a_(0.43f, 0.43f, 0.46f);
                matrix.func_227861_a_(-0.09, 0.06, 0.0);
                YUKATA_LEFT_ARM.getModel().getModel().animate();
                YUKATA_LEFT_ARM.getModel().render(matrix, vertices, light, overlay);
            }
        }
    }
}

