/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.ModelHolder;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LayerSash
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private final ResourceLocation normalSash = ResourceLocationHelper.of("pixelmon:textures/playeritems/otherstuff.png");
    private final ResourceLocation boostSash = ResourceLocationHelper.of("pixelmon:textures/playeritems/boost_sash.png");
    private final ResourceLocation adminSash = ResourceLocationHelper.of("pixelmon:textures/playeritems/admin.png");
    private final ResourceLocation developerSash = ResourceLocationHelper.of("pixelmon:textures/playeritems/developer.png");
    private final ResourceLocation moddelerSash = ResourceLocationHelper.of("pixelmon:textures/playeritems/modeler.png");
    private final ResourceLocation supportSash = ResourceLocationHelper.of("pixelmon:textures/playeritems/support.png");
    private final ModelHolder<GenericSmdModel> SASH_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/sash/sash.pqc");
    private final PlayerRenderer renderer;
    private ResourceLocation locationSashBG;
    private DynamicTexture sashBG;
    private boolean init = false;

    public LayerSash(PlayerRenderer renderer) {
        super((IEntityRenderer)renderer);
        this.renderer = renderer;
    }

    public void render(MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        String[] balls;
        ResourceLocation tex;
        PixelExtrasData extras;
        if (!this.init) {
            this.sashBG = new DynamicTexture(1, 1, true);
            this.sashBG.func_195414_e().func_195700_a(0, 0, -1);
            this.sashBG.func_110564_a();
            this.locationSashBG = Minecraft.func_71410_x().func_110434_K().func_110578_a("sashbg2", this.sashBG);
            this.init = true;
        }
        if (!(extras = PlayerExtraDataStore.get((PlayerEntity)player)).isReady() || !extras.isEnabled(PixelExtrasData.Category.SASH) || extras.getSashType() == PixelExtrasData.SashType.NONE || player.func_82150_aj()) {
            return;
        }
        float scale = 1.0f;
        int packedOverlay = LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f);
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("layer_sash");
        ModelRenderer body = ((PlayerModel)this.renderer.func_217764_d()).field_78115_e;
        matrix.func_227860_a_();
        boolean needsColouring = false;
        ResourceLocation texture = this.normalSash;
        switch (extras.getSashType()) {
            case RANK_ADMIN: 
            case RANK_JR: {
                texture = this.adminSash;
                break;
            }
            case RANK_DEV: {
                texture = this.developerSash;
                break;
            }
            case RANK_MODELER: {
                texture = this.moddelerSash;
                break;
            }
            case RANK_SUPPORT: {
                texture = this.supportSash;
                break;
            }
            case BOOSTER: {
                texture = this.boostSash;
                break;
            }
            default: {
                needsColouring = true;
            }
        }
        body.func_228307_a_(matrix);
        matrix.func_227861_a_(0.0, 1.5, 0.0);
        if (!((ItemStack)player.field_71071_by.field_70460_b.get(2)).func_190926_b() || extras.isEnabled(PixelExtrasData.Category.ROBE)) {
            matrix.func_227862_a_(scale, scale, scale + 0.31f);
        } else {
            matrix.func_227862_a_(scale, scale, scale);
        }
        if (extras.getSashType() == PixelExtrasData.SashType.RAINBOW) {
            IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(this.locationSashBG));
            int i = player.field_70173_aa / 25 + player.func_145782_y();
            int j = DyeColor.values().length;
            int k = i % j;
            int l = (i + 1) % j;
            float f7 = ((float)(player.field_70173_aa % 25) + partialTicks) / 25.0f;
            float[] afloat1 = SheepEntity.func_175513_a((DyeColor)DyeColor.func_196056_a((int)k));
            float[] afloat2 = SheepEntity.func_175513_a((DyeColor)DyeColor.func_196056_a((int)l));
            float r = afloat1[0] * (1.0f - f7) + afloat2[0] * f7;
            float g = afloat1[1] * (1.0f - f7) + afloat2[1] * f7;
            float b = afloat1[2] * (1.0f - f7) + afloat2[2] * f7;
            this.sashBG.func_195414_e().func_195700_a(0, 0, 0xFF000000 | (int)((double)(r * 255.0f) + 0.5) << 16 | (int)((double)(g * 255.0f) + 0.5) << 8 | (int)((double)(b * 255.0f) + 0.5));
            this.sashBG.func_110564_a();
            this.SASH_MODEL.getModel().getModel().animate();
            this.SASH_MODEL.getModel().func_225598_a_(matrix, vertices, packedLight, packedOverlay, r, g, b, 1.0f);
            needsColouring = false;
        }
        if (needsColouring) {
            IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(this.locationSashBG));
            float[] color = new float[3];
            if (extras.getColours(PixelExtrasData.Category.SASH)[0] != -1) {
                color[0] = extras.getColours(PixelExtrasData.Category.SASH)[0];
                color[1] = extras.getColours(PixelExtrasData.Category.SASH)[1];
                color[2] = extras.getColours(PixelExtrasData.Category.SASH)[2];
            } else {
                color[0] = 183.0f;
                color[1] = 42.0f;
                color[2] = 53.0f;
            }
            this.sashBG.func_195414_e().func_195700_a(0, 0, 0xFF000000 | (int)color[0] << 16 | (int)color[1] << 8 | (int)color[2]);
            this.sashBG.func_110564_a();
            this.SASH_MODEL.getModel().getModel().animate();
            this.SASH_MODEL.getModel().func_225598_a_(matrix, vertices, packedLight, packedOverlay, color[0], color[1], color[2], 1.0f);
            tex = this.normalSash;
        } else {
            tex = texture;
        }
        IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(tex));
        this.SASH_MODEL.getModel().getModel().animate();
        this.SASH_MODEL.getModel().render(matrix, vertices, packedLight, packedOverlay);
        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        matrix.func_227861_a_(-0.175, 1.44, 0.15);
        for (String ball : balls = EntityPlayerExtension.getPlayerPokeballs((PlayerEntity)player)) {
            PokeBall pokeball;
            if (ball == null || ball.isEmpty() || (pokeball = PokeBallRegistry.getPokeBall(ball).orElse((PokeBall)null)) == null) continue;
            matrix.func_227861_a_(0.0275, -0.05, 0.0);
            IVertexBuilder ballVertices = buffer.getBuffer(PixelmonRendering.getOBJRenderType(pokeball.getModelTexture()));
            matrix.func_227860_a_();
            matrix.func_227862_a_(6.0E-4f, 6.0E-4f, 6.0E-4f);
            ((ModelPokeballs)((Object)pokeball.getModelHolder().getModel())).getTheModel().animate();
            ((ModelPokeballs)((Object)pokeball.getModelHolder().getModel())).func_225598_a_(matrix, ballVertices, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }
}

