/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles.beams;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.DeceleratingParticle;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class EvolutionBeamParticle
extends DeceleratingParticle {
    public static final IParticleRenderType EVO_BEAM = new IParticleRenderType(){
        private final ResourceLocation EMPTY_TEX = ResourceLocationHelper.of("pixelmon:textures/entity/pixel.png");

        public void func_217600_a(BufferBuilder buffer, TextureManager p_217600_2_) {
            buffer.func_181668_a(7, DefaultVertexFormats.field_227850_m_);
            Minecraft.func_71410_x().field_71460_t.func_228385_m_().func_229198_a_();
            RenderSystem.disableCull();
            RenderSystem.enableAlphaTest();
            RenderSystem.alphaFunc((int)516, (float)0.003921569f);
            RenderSystem.disableBlend();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.enableTexture();
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            textureManager.func_110577_a(this.EMPTY_TEX);
            textureManager.func_229267_b_(this.EMPTY_TEX).func_174937_a(false, false);
        }

        public void func_217599_a(Tessellator p_217599_1_) {
            p_217599_1_.func_78381_a();
            Minecraft.func_71410_x().field_71460_t.func_228385_m_().func_229203_b_();
            RenderSystem.enableCull();
            RenderSystem.disableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.shadeModel((int)7424);
        }

        public String toString() {
            return "EVO_BEAM";
        }
    };
    private static final int BLOCK_LIGHT = 15;
    private static final int SKY_LIGHT = 15;
    private static final int FULL_BRIGHTNESS_VALUE = LightTexture.func_228451_a_((int)15, (int)15);
    private int ticks = 0;
    private int beams;

    public EvolutionBeamParticle(ClientWorld world, double x, double y, double z, int beams, int lifetime, double velocityX, double velocityY, double velocityZ, Color tint, double diameter, IAnimatedSprite sprites) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.func_70538_b(tint.getRGBComponents(null)[0], tint.getRGBComponents(null)[1], tint.getRGBComponents(null)[2]);
        this.func_187115_a((float)diameter, (float)diameter);
        this.field_70547_e = lifetime;
        this.beams = beams;
        this.field_82339_as = tint.getRGBComponents(null)[3];
        this.field_190017_n = false;
    }

    public boolean shouldCull() {
        return false;
    }

    public int func_189214_a(float partialTick) {
        int BLOCK_LIGHT = 15;
        int SKY_LIGHT = 15;
        int FULL_BRIGHTNESS_VALUE = LightTexture.func_228451_a_((int)15, (int)15);
        return FULL_BRIGHTNESS_VALUE;
    }

    public IParticleRenderType func_217558_b() {
        return EVO_BEAM;
    }

    public void func_225606_a_(IVertexBuilder builder, ActiveRenderInfo renderInfo, float partialTicks) {
        this.drawBeam(0.1f, this.field_187134_n, builder, renderInfo, partialTicks);
    }

    private void drawBeam(float width, float length, IVertexBuilder builder, ActiveRenderInfo renderInfo, float partialTicks) {
        Vector3d lvt_4_1_ = renderInfo.func_216785_c();
        float x = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - lvt_4_1_.func_82615_a());
        float y = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - lvt_4_1_.func_82617_b());
        float z = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - lvt_4_1_.func_82616_c());
        Vector3f[] points = new Vector3f[]{new Vector3f(-width, length, 0.0f), new Vector3f(width, length, 0.0f), new Vector3f(width * 3.0f, -length, 0.0f), new Vector3f(-width * 3.0f, -length, 0.0f), new Vector3f(0.0f, length, -width), new Vector3f(0.0f, length, width), new Vector3f(0.0f, -length, width * 3.0f), new Vector3f(0.0f, -length, -width * 3.0f)};
        float delta = 360.0f / (float)this.beams;
        for (int i = 0; i < this.beams; ++i) {
            this.renderBeam(builder, renderInfo, points, (float)i * delta, x, y, z, partialTicks);
        }
    }

    private void renderBeam(IVertexBuilder builder, ActiveRenderInfo renderInfo, Vector3f[] points, float offset, float x, float y, float z, float partialTicks) {
        for (int i = 0; i < points.length; ++i) {
            Vector3f point = points[i].func_229195_e_();
            point.func_214905_a(renderInfo.func_227995_f_());
            point.func_214905_a(QuaternionHelper.fromEuler(offset + (float)this.ticks * 3.0f, 0.0f, 1.0f, 0.0f));
            point.func_195904_b(x, y, z);
            builder.func_225582_a_((double)point.func_195899_a(), (double)point.func_195900_b(), (double)point.func_195902_c()).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(this.func_189214_a(partialTicks)).func_181675_d();
        }
    }

    public void func_189213_a() {
        super.func_189213_a();
        ++this.ticks;
    }
}

