/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class Leaf
extends ParticleEffect {
    private static final ResourceLocation TEX_1 = ResourceLocationHelper.of("pixelmon", "textures/particle/petal.png");
    private static final ResourceLocation TEX_2 = ResourceLocationHelper.of("pixelmon", "textures/particle/leaf.png");
    private final double swingArc;
    private short timeOnGround = 0;
    private double currentRot = 0.0;
    private boolean rotIncreasing = true;
    private final float scale;
    private final boolean shiny;

    public Leaf(double swingArc, float scale, boolean shiny) {
        this.swingArc = swingArc;
        this.scale = scale;
        this.shiny = shiny;
    }

    @Override
    public void preRender(ParticleArcanery particle, float partialTicks) {
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    @Override
    public void init(ParticleArcanery particle, World world, double x, double y, double z, double vx, double vy, double vz, float size) {
        particle.setRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        particle.setMotion(particle.getMotionX() + vx, particle.getMotionY() + vy, particle.getMotionZ() + vz);
        particle.func_187114_a(40);
    }

    @Override
    public void update(ParticleArcanery particle) {
        BlockPos blockPos;
        ClientWorld clientWorld;
        particle.setPrevPos(particle.getX(), particle.getY(), particle.getZ());
        particle.incrementAge();
        if (particle.getAge() > 15 && (clientWorld = Minecraft.func_71410_x().field_71441_e).func_180495_p(blockPos = new BlockPos(particle.getX(), particle.getY() - 0.3, particle.getZ())).func_224755_d((IBlockReader)clientWorld, blockPos, Direction.UP)) {
            particle.setOnGround();
        }
        if (particle.onGround()) {
            this.timeOnGround = (short)(this.timeOnGround + 1);
            particle.setRGBA(1.0f, 1.0f - (float)this.timeOnGround / (float)particle.func_206254_h() / 2.5f, 1.0f - (float)this.timeOnGround / (float)particle.func_206254_h(), 1.0f - (float)this.timeOnGround / (float)particle.func_206254_h());
        } else {
            if (particle.getMotionY() < 0.0) {
                if (this.rotIncreasing) {
                    this.currentRot += 0.2 * Math.max(0.2, Math.abs(this.swingArc + this.currentRot));
                    particle.setAngle((float)this.currentRot);
                    if ((double)particle.getAngle() >= this.swingArc) {
                        this.rotIncreasing = false;
                    }
                } else {
                    this.currentRot -= 0.2 * Math.max(0.2, Math.abs(this.swingArc - this.currentRot));
                    particle.setAngle((float)this.currentRot);
                    if ((double)particle.getAngle() <= -this.swingArc) {
                        this.rotIncreasing = true;
                    }
                }
            }
            particle.func_187110_a(particle.getMotionX(), particle.getMotionY(), particle.getMotionZ());
            particle.setMotion(particle.getMotionX() / 2.0, Math.max(-0.15, particle.getMotionY() - 0.1), particle.getMotionZ() / 2.0);
        }
        if (this.timeOnGround >= particle.func_206254_h()) {
            particle.func_187112_i();
        }
    }

    @Override
    public ResourceLocation texture() {
        if (this.shiny) {
            return TEX_1;
        }
        return TEX_2;
    }
}

