/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.decorative.ContainerPlusBlock;
import com.pixelmonmod.pixelmon.blocks.decorative.FancyPillarBlock;
import com.pixelmonmod.pixelmon.blocks.enums.EnumAxis;
import com.pixelmonmod.pixelmon.blocks.tileentity.DecorativeBaseTileEntity;
import com.pixelmonmod.pixelmon.client.models.ModelCustomWrapper;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRenderer;
import com.pixelmonmod.pixelmon.client.models.blocks.ModelEntityBlock;
import com.pixelmonmod.pixelmon.enums.CustomModel;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;

public class ModelFancyPillar
extends ModelEntityBlock<DecorativeBaseTileEntity> {
    private static final ResourceLocation pillar = ResourceLocationHelper.of("pixelmon:textures/block/pillar.png");
    private static final ResourceLocation pillarDamaged = ResourceLocationHelper.of("pixelmon:textures/block/pillar_fractured.png");
    PixelmonModelRenderer platform = new PixelmonModelRenderer(this);
    PixelmonModelRenderer column = new PixelmonModelRenderer(this);
    PixelmonModelRenderer fracturedBottom = new PixelmonModelRenderer(this);
    PixelmonModelRenderer fracturedTop = new PixelmonModelRenderer(this);

    public ModelFancyPillar(Function<ResourceLocation, RenderType> renderTypeIn) {
        super(renderTypeIn);
        this.platform.addCustomModel(new ModelCustomWrapper(CustomModel.PILLAR_PLATFORM.getModel()));
        this.column.addCustomModel(new ModelCustomWrapper(CustomModel.PILLAR_COLUMN.getModel()));
        this.fracturedBottom.addCustomModel(new ModelCustomWrapper(CustomModel.PILLAR_COLUMN_FRACTURED_BOTTOM.getModel()));
        this.fracturedTop.addCustomModel(new ModelCustomWrapper(CustomModel.PILLAR_COLUMN_FRACTURED_TOP.getModel()));
    }

    @Override
    public void renderTileEntity(DecorativeBaseTileEntity tileEnt, MatrixStack matrix, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        BlockState state = tileEnt.func_195044_w();
        FancyPillarBlock theBlock = (FancyPillarBlock)state.func_177230_c();
        FancyPillarBlock.Connections connections = theBlock.getConnections((IWorld)tileEnt.func_145831_w(), tileEnt.func_174877_v(), state);
        matrix.func_227860_a_();
        RenderSystem.enableRescaleNormal();
        if (!theBlock.getIsDamaged(state)) {
            this.renderStandardPillar(connections, matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        } else {
            this.renderDamagedPillar(connections, matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha, tileEnt);
        }
        matrix.func_227865_b_();
    }

    public void renderStandardPillar(FancyPillarBlock.Connections connections, MatrixStack matrix, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pillar);
        this.column.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        if (!connections.top) {
            this.platform.func_78793_a(0.0f, 6.5f, 0.0f);
            this.platform.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        if (!connections.bottom) {
            this.platform.func_78793_a(0.0f, -6.5f, 0.0f);
            this.platform.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    public void renderDamagedPillarInv(MatrixStack matrix, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pillarDamaged);
        this.platform.func_78793_a(0.0f, 6.5f, 0.0f);
        this.platform.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.platform.func_78793_a(0.0f, -6.5f, 0.0f);
        this.platform.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.fracturedBottom.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.fracturedTop.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderDamagedPillar(FancyPillarBlock.Connections connections, MatrixStack matrix, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, DecorativeBaseTileEntity tileEnt) {
        Boolean topState;
        Boolean bottomState;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pillarDamaged);
        BlockState state = tileEnt.func_195044_w();
        FancyPillarBlock theBlock = (FancyPillarBlock)state.func_177230_c();
        boolean renderTopPlatform = false;
        boolean renderBotPlatform = false;
        boolean renderTopDamaged = false;
        boolean renderBotDamaged = false;
        EnumAxis axis = (EnumAxis)((Object)state.func_177229_b(ContainerPlusBlock.AXIS));
        int index = axis.ordinal() - 1;
        if (index < 0) {
            index = 0;
        }
        if ((bottomState = theBlock.isEnd(tileEnt.func_145831_w(), tileEnt.func_174877_v(), FancyPillarBlock.DOWN[index])) != null) {
            if (!bottomState.booleanValue()) {
                renderBotPlatform = true;
            } else if (bottomState.booleanValue()) {
                renderBotDamaged = true;
            }
        }
        if ((topState = theBlock.isEnd(tileEnt.func_145831_w(), tileEnt.func_174877_v(), FancyPillarBlock.UP[index])) != null) {
            if (!topState.booleanValue()) {
                renderTopPlatform = true;
            } else if (topState.booleanValue()) {
                renderTopDamaged = true;
            }
        }
        if (renderBotDamaged) {
            this.fracturedTop.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        if (renderTopDamaged) {
            this.fracturedBottom.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        if (renderTopPlatform) {
            this.platform.func_78793_a(0.0f, -6.5f, 0.0f);
            this.platform.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            if (!renderTopDamaged && !renderBotDamaged) {
                this.column.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
        if (renderBotPlatform) {
            this.platform.func_78793_a(0.0f, 6.5f, 0.0f);
            this.platform.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            if (!renderTopDamaged && !renderBotDamaged) {
                this.column.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
        if (!(renderTopDamaged || renderBotDamaged || renderTopPlatform || renderBotPlatform)) {
            this.column.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }
}

