/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.zygarde;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.PowerConstruct;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.RoundButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.zygarde.ZygardeCubePacket;
import com.pixelmonmod.pixelmon.items.ZygardeCubeItem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.text.StringTextComponent;

public class ZygardeCubeScreen
extends Screen {
    Hand hand;
    StoragePosition position;
    Pokemon zygarde;
    ItemStack cube;
    Mode mode = Mode.SELECT;
    List<RoundButton> field_230710_m_ = Lists.newArrayList();
    List<String> lines = Lists.newArrayList();
    private int centerW;
    private int centerH;

    public ZygardeCubeScreen(Hand hand, int partyPos) {
        super(StringTextComponent.field_240750_d_);
        ItemStack stack;
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.hand = hand;
        this.position = new StoragePosition(-1, partyPos);
        Pokemon pokemon = ClientStorageManager.party.get(this.position);
        if (pokemon.getSpecies().is(PixelmonSpecies.ZYGARDE)) {
            this.zygarde = pokemon;
        }
        if ((stack = this.field_230706_i_.field_71439_g.func_184586_b(hand)).func_77973_b() instanceof ZygardeCubeItem) {
            this.cube = stack;
        }
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.centerW = this.field_230708_k_ / 2;
        this.centerH = this.field_230709_l_ / 2;
        this.field_230710_m_.clear();
        this.lines.clear();
        if (this.cube == null || this.zygarde == null) {
            this.field_230706_i_.func_147108_a(null);
            return;
        }
        if (this.mode == Mode.SELECT) {
            if (!(this.zygarde.getAbility() instanceof PowerConstruct) && ZygardeCubeItem.getCoreTypes(this.cube).size() == 0) {
                this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_cube.nomoves", (Object[])new Object[0]));
                this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"gui.button.okay", (Object[])new Object[0]), 150, 20).setId(-1));
            } else if (this.zygarde.getAbility() instanceof PowerConstruct) {
                this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_cube.select", (Object[])new Object[0]));
                if (this.zygarde.getAbility() instanceof PowerConstruct) {
                    this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"pixelmon.gui.zygarde_cube.toggleforme", (Object[])new Object[0]), 150, 20).setId(0));
                }
                if (ZygardeCubeItem.getCoreTypes(this.cube).size() > 0) {
                    this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"pixelmon.gui.zygarde_cube.teachmove", (Object[])new Object[0]), 150, 20).setId(1));
                }
            } else {
                this.mode = Mode.LEARN_MOVE;
            }
        }
        if (this.mode == Mode.LEARN_MOVE) {
            this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_cube.learnmove", (Object[])new Object[0]));
            for (ZygardeCubeItem.CoreType type : ZygardeCubeItem.getCoreTypes(this.cube)) {
                ImmutableAttack base = type.getMove();
                this.field_230710_m_.add(new RoundButton(0, 0, base.getLocalizedName(), 150, 20).setId(type.ordinal()));
            }
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        if (!this.lines.isEmpty()) {
            ScreenHelper.drawDialogueBox(matrix, (Screen)this, "", this.lines, 0.0f);
        }
        for (int i = 0; i < this.field_230710_m_.size(); ++i) {
            RoundButton button = this.field_230710_m_.get(i);
            button.drawButton(matrix, this.centerW - 70, this.field_230709_l_ / 4 + 20 + 30 * (i + 1), mouseX, mouseY, 0.0f);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        for (int i = 0; i < this.field_230710_m_.size(); ++i) {
            RoundButton button = this.field_230710_m_.get(i);
            if (!button.isMouseOver(this.centerW - 70, this.field_230709_l_ / 4 + 20 + 30 * (i + 1), mouseX, mouseY)) continue;
            if (this.mode == Mode.SELECT) {
                if (button.getId() == 0) {
                    NetworkHelper.sendToServer(new ZygardeCubePacket(this.position, this.field_230706_i_.field_71439_g.field_71071_by.func_184429_b(this.cube)));
                    this.field_230706_i_.func_147108_a(null);
                    continue;
                }
                if (button.getId() == 1) {
                    this.mode = Mode.LEARN_MOVE;
                    this.func_231160_c_();
                    continue;
                }
                if (button.getId() != -1) continue;
                this.field_230706_i_.func_147108_a(null);
                continue;
            }
            if (this.mode != Mode.LEARN_MOVE) continue;
            NetworkHelper.sendToServer(new ZygardeCubePacket(this.position, this.field_230706_i_.field_71439_g.field_71071_by.func_184429_b(this.cube), button.getId()));
            this.field_230706_i_.func_147108_a(null);
        }
        return false;
    }

    static enum Mode {
        SELECT,
        LEARN_MOVE,
        TOGGLE_FORM;

    }
}

