/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pc;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.storage.PCBox;
import com.pixelmonmod.pixelmon.api.storage.PCStorageSearch;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.pc.PokemonScreen;
import com.pixelmonmod.pixelmon.client.gui.pc.ReleaseWarningScreen;
import com.pixelmonmod.pixelmon.client.gui.pc.TrashCanButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.ArrowButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.ImageClickableButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.KeybindIcon;
import com.pixelmonmod.pixelmon.client.listener.WallpapersListener;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc.ServerSetLastOpenBoxPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PCScreen
extends PokemonScreen {
    public static PCStorageSearch search;
    protected ImageClickableButton leftArrow;
    protected ImageClickableButton rightArrow;
    protected ImageClickableButton boxButton;
    protected ArrowButton leftArrowWallpaper;
    protected ArrowButton rightArrowWallpaper;
    protected TextFieldWidget nameField;
    protected TextFieldWidget searchField;
    protected List<KeybindIcon> icons = new ArrayList<KeybindIcon>();
    protected KeybindIcon searchIcon;
    protected KeybindIcon renameIcon;
    protected KeybindIcon wallpaperIcon = new KeybindIcon(ClientProxy.pcWallpaperKeyBind, Resources.pcWallpaperIcon);
    protected ResourceLocation boxWallpaper;
    private int normalBoxCount;
    private boolean blockTyping = false;

    public PCScreen(@Nullable StoragePosition selected) {
        super(selected);
        this.icons.add(this.wallpaperIcon);
        this.renameIcon = new KeybindIcon(ClientProxy.pcRenameKeyBind, Resources.pcRenameIcon);
        this.icons.add(this.renameIcon);
        this.searchIcon = new KeybindIcon(ClientProxy.pcSearchKeyBind, Resources.pcSearchIcon);
        this.icons.add(this.searchIcon);
        this.leftArrow = new ImageClickableButton(0, 0, 0, 0, 186, 17, 23, this::actionPerformed);
        this.rightArrow = new ImageClickableButton(1, 0, 0, 143, 186, 17, 23, this::actionPerformed);
        this.boxButton = new ImageClickableButton(2, 0, 0, 22, 186, 116, 23, this::actionPerformed);
        this.boxButton.field_230693_o_ = false;
        this.leftArrowWallpaper = new ArrowButton(4, 0, 0, ArrowButton.Direction.LEFT, this::actionPerformed);
        this.leftArrowWallpaper.field_230693_o_ = false;
        this.leftArrowWallpaper.field_230694_p_ = false;
        this.rightArrowWallpaper = new ArrowButton(5, 0, 0, ArrowButton.Direction.RIGHT, this::actionPerformed);
        this.rightArrowWallpaper.field_230693_o_ = false;
        this.rightArrowWallpaper.field_230694_p_ = false;
        this.nameField = new TextFieldWidget(this.field_230712_o_, 0, 0, 116, 23, StringTextComponent.field_240750_d_);
        this.nameField.func_146193_g(0xFFFFFF);
        this.nameField.func_146203_f(17);
        this.nameField.func_146185_a(false);
        this.nameField.func_146205_d(false);
        this.nameField.func_146189_e(false);
        this.searchField = new TextFieldWidget(this.field_230712_o_, 0, 0, 114, 23, StringTextComponent.field_240750_d_);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146203_f(35);
        this.searchField.func_146189_e(false);
        this.updateBox(this.boxNumber);
    }

    public PCScreen() {
        this(null);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.func_230480_a_((Widget)this.leftArrow.updatePosition(this.field_230708_k_ / 2 - 80, this.field_230709_l_ / 6 - 21));
        this.func_230480_a_((Widget)this.rightArrow.updatePosition(this.field_230708_k_ / 2 + 63, this.field_230709_l_ / 6 - 21));
        this.func_230480_a_((Widget)this.boxButton.updatePosition(this.field_230708_k_ / 2 - 58, this.field_230709_l_ / 6 - 21));
        this.func_230480_a_((Widget)new TrashCanButton(this, 3, this.field_230708_k_ / 2 + 111, this.field_230709_l_ / 6 + 110, this::actionPerformed));
        this.func_230480_a_((Widget)this.leftArrowWallpaper.updatePosition(this.field_230708_k_ / 2 - 125, this.field_230709_l_ / 6 + 58));
        this.func_230480_a_((Widget)this.rightArrowWallpaper.updatePosition(this.field_230708_k_ / 2 + 108, this.field_230709_l_ / 6 + 58));
        this.nameField.field_146211_a = this.field_230712_o_;
        this.nameField.field_230690_l_ = this.field_230708_k_ / 2 - 51;
        this.nameField.field_230691_m_ = this.field_230709_l_ / 6 - 14;
        this.func_230481_d_((IGuiEventListener)this.nameField);
        this.searchField.field_146211_a = this.field_230712_o_;
        this.searchField.field_230690_l_ = this.field_230708_k_ / 2 - 57;
        this.searchField.field_230691_m_ = this.field_230709_l_ / 6 - 20;
        this.searchField.func_212954_a(s -> {
            if (s.isEmpty()) {
                return;
            }
            if (this.boxNumber != 0) {
                this.updateBox(0);
            }
            search.query((String)s);
        });
        this.func_230481_d_((IGuiEventListener)this.searchField);
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        PixelmonOverlayScreen.ICONS.forEach(icon -> icon.setEnabled(false));
    }

    private void updateBox(int boxNumber) {
        int oldBox = this.boxNumber;
        this.boxNumber = boxNumber;
        if (this.boxNumber < 0) {
            this.boxNumber = this.storage.getBoxCount() - 1;
        } else if (this.boxNumber >= this.storage.getBoxCount()) {
            this.boxNumber = 0;
        }
        this.storage.setLastBox(this.boxNumber);
        PCBox data = this.storage.getBox(this.boxNumber);
        this.updateName(data);
        this.updateWallpaper(data);
        if (oldBox != boxNumber) {
            this.leftArrowWallpaper.field_230693_o_ = false;
            this.leftArrowWallpaper.field_230694_p_ = false;
            this.rightArrowWallpaper.field_230693_o_ = false;
            this.rightArrowWallpaper.field_230694_p_ = false;
        }
    }

    protected void updateName(PCBox data) {
        this.boxButton.func_238482_a_((ITextComponent)(data.getName() == null ? new TranslationTextComponent("gui.pc.box", new Object[]{this.boxNumber + 1}) : new StringTextComponent(data.getName())));
    }

    protected void updateWallpaper(PCBox data) {
        if (!WallpapersListener.hasWallpaper(data.getWallpaper())) {
            data.setWallpaper(null);
        }
        this.boxWallpaper = WallpapersListener.getWallpaper(data.getWallpaper());
        this.leftArrow.setImage(this.boxWallpaper);
        this.rightArrow.setImage(this.boxWallpaper);
        this.boxButton.setImage(this.boxWallpaper);
    }

    protected void switchWallpaper(boolean forward) {
        PCBox data = this.storage.getBox(this.boxNumber);
        int index = (data.getWallpaper() == null ? 0 : WallpapersListener.getWallpapers().indexOf(data.getWallpaper())) + (forward ? 1 : -1);
        if (index < 0) {
            index = WallpapersListener.getWallpapers().size() - 1;
        } else if (index >= WallpapersListener.getWallpapers().size()) {
            index = 0;
        }
        data.setWallpaper(WallpapersListener.getWallpapers().get(index));
        this.updateWallpaper(data);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void actionPerformed(Button button) {
        if (button instanceof IndexedButton) {
            switch (((IndexedButton)button).id) {
                case 0: {
                    this.updateBox(this.boxNumber - 1);
                    break;
                }
                case 1: {
                    this.updateBox(this.boxNumber + 1);
                    break;
                }
                case 3: {
                    this.field_230706_i_.func_147108_a((Screen)new ReleaseWarningScreen(this));
                    break;
                }
                case 4: {
                    this.switchWallpaper(false);
                    break;
                }
                case 5: {
                    this.switchWallpaper(true);
                }
            }
        }
    }

    private void closeSearch() {
        search = null;
        this.searchField.func_146195_b(false);
        this.searchField.func_146189_e(false);
        this.updateStorage(ClientStorageManager.openPC, this.selectedPokemon == null ? null : this.selectedPokemon.getPosition());
        this.updateBox(this.normalBoxCount);
    }

    private void closeName(boolean save) {
        if (save) {
            this.leftArrow.field_230693_o_ = true;
            this.rightArrow.field_230693_o_ = true;
            PCBox data = this.storage.getBox(this.boxNumber);
            data.setName(this.nameField.func_146179_b().equals(I18n.func_135052_a((String)"gui.pc.box", (Object[])new Object[]{this.boxNumber + 1})) ? null : this.nameField.func_146179_b());
            this.updateName(data);
            this.nameField.func_146189_e(false);
            this.searchField.func_146195_b(false);
        } else {
            this.leftArrow.field_230693_o_ = true;
            this.rightArrow.field_230693_o_ = true;
            this.updateName(this.storage.getBox(this.boxNumber));
            this.nameField.func_146189_e(false);
            this.searchField.func_146195_b(false);
        }
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.searchField.func_146176_q()) {
            if (keyCode == 256) {
                this.closeSearch();
                return false;
            }
            if (keyCode == 257) {
                this.searchField.func_146195_b(false);
                return false;
            }
            return super.func_231046_a_(keyCode, scanCode, modifiers);
        }
        if (this.nameField.func_146176_q()) {
            if (keyCode == 256) {
                this.closeName(false);
                return false;
            }
            if (keyCode == 257) {
                this.closeName(true);
                return false;
            }
            return super.func_231046_a_(keyCode, scanCode, modifiers);
        }
        if (keyCode == ClientProxy.pcSearchKeyBind.getKey().func_197937_c()) {
            if (!this.searchField.func_146176_q()) {
                this.searchField.func_146189_e(true);
                this.searchField.func_146180_a("");
                this.searchField.func_146195_b(true);
                this.func_231035_a_((IGuiEventListener)this.searchField);
                this.updateSelected(null);
                search = new PCStorageSearch(6, 5);
                this.updateStorage(search, this.selected);
                this.normalBoxCount = this.boxNumber;
                this.updateBox(this.boxNumber);
                this.blockTyping = true;
                return true;
            }
        } else if (keyCode == ClientProxy.pcRenameKeyBind.getKey().func_197937_c()) {
            if (!this.nameField.func_146176_q()) {
                this.leftArrow.field_230693_o_ = false;
                this.rightArrow.field_230693_o_ = false;
                this.nameField.func_146189_e(true);
                this.nameField.func_146180_a(this.boxButton.func_230458_i_().getString());
                this.boxButton.func_238482_a_(StringTextComponent.field_240750_d_);
                this.nameField.func_146195_b(true);
                this.func_231035_a_((IGuiEventListener)this.nameField);
                this.blockTyping = true;
            }
        } else if (keyCode == ClientProxy.pcWallpaperKeyBind.getKey().func_197937_c()) {
            boolean state;
            this.leftArrowWallpaper.field_230693_o_ = state = !this.leftArrowWallpaper.field_230693_o_;
            this.leftArrowWallpaper.field_230694_p_ = state;
            this.rightArrowWallpaper.field_230693_o_ = state;
            this.rightArrowWallpaper.field_230694_p_ = state;
            if (!state) {
                Arrays.stream(ClientStorageManager.openPC.getBoxes()).forEach(PCBox::sendChangesToServer);
            }
        } else if (keyCode == 263) {
            this.switchOrSound(this.leftArrowWallpaper.field_230693_o_ ? this.leftArrowWallpaper : this.leftArrow);
        } else if (keyCode == 262) {
            this.switchOrSound(this.rightArrowWallpaper.field_230693_o_ ? this.rightArrowWallpaper : this.rightArrow);
        } else {
            if (keyCode == 256) {
                this.field_230706_i_.func_147108_a(null);
                return true;
            }
            super.func_231046_a_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    private void press(Button button) {
        if (button.field_230693_o_) {
            this.actionPerformed(button);
            button.func_230988_a_(this.field_230706_i_.func_147118_V());
        }
    }

    private void switchOrSound(Button button) {
        if (this.storage.getBoxCount() > 1) {
            this.press(button);
        } else {
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.nameField.func_231044_a_(mouseX, mouseY, mouseButton);
        this.searchField.func_231044_a_(mouseX, mouseY, mouseButton);
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_231164_f_() {
        if (this.searchField.func_146176_q()) {
            this.closeSearch();
        }
        if (this.nameField.func_146176_q()) {
            this.closeName(true);
        }
        Arrays.stream(ClientStorageManager.openPC.getBoxes()).forEach(PCBox::sendChangesToServer);
        NetworkHelper.sendToServer(new ServerSetLastOpenBoxPacket(this.boxNumber));
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        PixelmonOverlayScreen.ICONS.forEach(icon -> icon.setEnabled(true));
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        RenderSystem.enableBlend();
        this.field_230706_i_.func_110434_K().func_110577_a(this.boxWallpaper);
        this.func_238474_b_(matrix, this.field_230708_k_ / 2 - 103, this.field_230709_l_ / 6 - 30, 0, 0, 206, 186);
        for (IGuiEventListener child : this.field_230705_e_) {
            if (!(child instanceof Widget)) continue;
            ((Widget)child).func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        }
        for (int i = 0; i < this.icons.size(); ++i) {
            this.icons.get(i).draw(matrix, this.field_230708_k_ - 30 - i * 25, this.field_230709_l_ - 30, partialTicks);
        }
        RenderSystem.enableBlend();
        this.drawBox(matrix);
        this.drawFooter(matrix);
        this.drawPokeChecker(matrix, mouseX, mouseY, partialTicks);
        this.drawHover(matrix, mouseX, mouseY);
        this.drawCursor(matrix, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.nameField.func_146178_a();
        this.searchField.func_146178_a();
    }

    public boolean func_231042_a_(char p_231042_1_, int p_231042_2_) {
        if (this.blockTyping) {
            this.blockTyping = false;
            return false;
        }
        return super.func_231042_a_(p_231042_1_, p_231042_2_);
    }
}

