/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TrainerDropListSlotScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TrainerEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTextField;
import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTrainerDataPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class TrainerEditorMoreScreen
extends Screen {
    private Map<String, ItemStack> itemMap = new HashMap<String, ItemStack>();
    private Map<String, ItemStack> idMap = new HashMap<String, ItemStack>();
    private Map<String, ItemStack> modAndIdMap = new HashMap<String, ItemStack>();
    TextFieldWidget tfGreeting;
    TextFieldWidget tfWin;
    TextFieldWidget tfLose;
    TextFieldWidget tfDrop;
    TextFieldWidget tfWinMoney;
    protected int listTop;
    protected int listLeft;
    protected int listHeight;
    protected int listWidth;
    ArrayList<ItemStack> dropList = new ArrayList();
    TrainerDropListSlotScreen list;
    int lastWidth;
    int lastHeight;

    public TrainerEditorMoreScreen() {
        super(StringTextComponent.field_240750_d_);
        if (TrainerEditorScreen.trainerData == null) {
            TrainerEditorScreen.trainerData = new SetTrainerData("", "", "", "", 0, new ItemStack[0], new BattleRules());
        }
        Collections.addAll(this.dropList, TrainerEditorScreen.trainerData.winnings);
        ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).forEach(itemStack -> {
            NonNullList list = NonNullList.func_191196_a();
            list.add(itemStack);
            list.forEach(stack -> {
                this.itemMap.put(stack.func_200301_q().getString(), (ItemStack)stack);
                ResourceLocation location = stack.func_77973_b().getRegistryName();
                this.idMap.put(location.func_110623_a().toLowerCase(Locale.ROOT), (ItemStack)stack);
                this.modAndIdMap.put((location.func_110624_b() + ":" + location.func_110623_a()).toLowerCase(Locale.ROOT), (ItemStack)stack);
            });
        });
    }

    private void initList() {
        this.lastWidth = this.field_230708_k_;
        this.lastHeight = this.field_230709_l_;
        this.listTop = this.field_230709_l_ / 2 + 30;
        this.listLeft = this.field_230708_k_ / 2 - 160;
        this.listHeight = 80;
        this.listWidth = 100;
        this.list = new TrainerDropListSlotScreen(this);
        this.field_230705_e_.add(this.list);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.initList();
        this.field_230705_e_.add(new IndexedButton(1, this.field_230708_k_ / 2 + 155, this.field_230709_l_ / 2 + 90, 30, 20, (ITextComponent)new TranslationTextComponent("gui.guiItemDrops.ok"), this::actionPerformed));
        this.field_230705_e_.add(new IndexedButton(2, this.field_230708_k_ / 2 - 30, this.field_230709_l_ / 2 + 70, 80, 20, (ITextComponent)new TranslationTextComponent("gui.trainereditor.additem"), this::actionPerformed));
        this.tfGreeting = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 120, this.field_230709_l_ / 2 - 70, 280, 17, StringTextComponent.field_240750_d_);
        this.tfGreeting.func_146203_f(2000);
        this.tfGreeting.func_146180_a(TrainerEditorScreen.trainerData.greeting);
        this.field_230705_e_.add(this.tfGreeting);
        this.tfWin = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 120, this.field_230709_l_ / 2 - 50, 280, 17, StringTextComponent.field_240750_d_);
        this.tfWin.func_146203_f(2000);
        this.tfWin.func_146180_a(TrainerEditorScreen.trainerData.win);
        this.field_230705_e_.add(this.tfWin);
        this.tfLose = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 120, this.field_230709_l_ / 2 - 30, 280, 17, StringTextComponent.field_240750_d_);
        this.tfLose.func_146203_f(2000);
        this.tfLose.func_146180_a(TrainerEditorScreen.trainerData.lose);
        this.field_230705_e_.add(this.tfLose);
        this.tfDrop = new TabCompleteTextField(7, this.field_230712_o_, this.field_230708_k_ / 2 - 30, this.field_230709_l_ / 2 + 50, 120, 17).setCompletions(this.itemMap.keySet());
        this.field_230705_e_.add(this.tfDrop);
        this.tfWinMoney = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 + 110, this.field_230709_l_ / 2 + 50, 80, 20, StringTextComponent.field_240750_d_);
        this.tfWinMoney.func_146203_f(2000);
        this.tfWinMoney.func_146180_a(String.valueOf(TrainerEditorScreen.trainerData.winMoney));
        this.field_230705_e_.add(this.tfWinMoney);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, (float)this.field_230708_k_ / 2.0f - 200.0f, (float)this.field_230709_l_ / 2.0f - 120.0f, 400.0f, 240.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        RenderHelper.func_74518_a();
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor.moreinfo", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - (float)this.field_230706_i_.field_71466_p.func_78256_a(I18n.func_135052_a((String)"gui.trainereditor.moreinfo", (Object[])new Object[0])) / 2.0f, (float)this.field_230709_l_ / 2.0f - 90.0f, 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor.greeting", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 180.0f, (float)this.field_230709_l_ / 2.0f - 65.0f, 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor.win", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 180.0f, (float)this.field_230709_l_ / 2.0f - 45.0f, 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor.lose", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 180.0f, (float)this.field_230709_l_ / 2.0f - 25.0f, 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor.winningdrops", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 157.0f, (float)this.field_230709_l_ / 2.0f + 15.0f, 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor.adddrops", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 30.0f, (float)this.field_230709_l_ / 2.0f + 15.0f, 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor.enteritemname", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 30.0f, (float)this.field_230709_l_ / 2.0f + 30.0f, 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor.winmoney", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f + 110.0f, (float)this.field_230709_l_ / 2.0f + 30.0f, 0);
        for (IGuiEventListener child : this.field_230705_e_) {
            if (!(child instanceof Widget)) continue;
            ((Widget)child).func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        }
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
    }

    public boolean func_231042_a_(char key, int par2) {
        if (par2 == 256 || par2 == 257) {
            this.saveFields();
        }
        return super.func_231042_a_(key, par2);
    }

    public boolean func_231044_a_(double x, double y, int z) {
        return super.func_231044_a_(x, y, z);
    }

    protected void actionPerformed(Button button) {
        if (button instanceof IndexedButton) {
            int id = ((IndexedButton)button).id;
            if (id == 1) {
                this.saveFields();
            } else if (id == 2) {
                String itemString = this.tfDrop.func_146179_b();
                if (this.itemMap.containsKey(itemString)) {
                    this.dropList.add(this.itemMap.get(itemString).func_77946_l());
                } else if (this.idMap.containsKey(itemString.toLowerCase(Locale.ROOT))) {
                    this.dropList.add(this.idMap.get(itemString.toLowerCase(Locale.ROOT)).func_77946_l());
                } else if (this.modAndIdMap.containsKey(itemString.toLowerCase(Locale.ROOT))) {
                    this.dropList.add(this.modAndIdMap.get(itemString.toLowerCase(Locale.ROOT)).func_77946_l());
                } else {
                    try {
                        String[] split = itemString.split(":", 2);
                        int id2 = Integer.parseInt(split[0]);
                        if (Item.func_150899_d((int)id2) != null) {
                            this.dropList.add(new ItemStack((IItemProvider)Item.func_150899_d((int)id2)));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void saveFields() {
        ItemStack[] drops = new ItemStack[this.dropList.size()];
        for (int i = 0; i < this.dropList.size(); ++i) {
            drops[i] = this.dropList.get(i);
        }
        int winMoneyValue = TrainerEditorScreen.trainerData.winMoney;
        try {
            winMoneyValue = Math.max(0, Integer.parseInt(this.tfWinMoney.func_146179_b()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        SetTrainerData p = new SetTrainerData(TrainerEditorScreen.trainerData.name, this.tfGreeting.func_146179_b(), this.tfWin.func_146179_b(), this.tfLose.func_146179_b(), winMoneyValue, drops);
        p.id = TrainerEditorScreen.currentTrainerID;
        if (!(this.tfGreeting.func_146179_b().equals(TrainerEditorScreen.trainerData.greeting) && this.tfWin.func_146179_b().equals(TrainerEditorScreen.trainerData.win) && this.tfLose.func_146179_b().equals(TrainerEditorScreen.trainerData.lose) && winMoneyValue == TrainerEditorScreen.trainerData.winMoney)) {
            NetworkHelper.sendToServer(new StoreTrainerDataPacket(TrainerEditorScreen.currentTrainerID, p));
        }
        NetworkHelper.sendToServer(new StoreTrainerDataPacket(TrainerEditorScreen.currentTrainerID, drops));
        TrainerEditorScreen.trainerData = p;
        this.field_230706_i_.func_147108_a((Screen)new TrainerEditorScreen(TrainerEditorScreen.currentTrainerID));
    }

    public int getDropListCount() {
        return this.dropList.size();
    }

    public void removeFromList(int ind) {
        this.dropList.remove(ind);
    }

    public ItemStack getDropListEntry(int ind) {
        if (ind < this.dropList.size() && ind >= 0) {
            return this.dropList.get(ind);
        }
        return null;
    }
}

