/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.accessors.TCGBlocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.client.util.SearchTreeReloadable;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

public class SearchTreeExtender
implements ISelectiveResourceReloadListener {
    private static final Set<Object> ADDED_ITEMS = Sets.newHashSet();

    public void onResourceManagerReload(IResourceManager manager, Predicate<IResourceType> resourcePredicate) {
        SearchTreeExtender.reloadSearchTrees();
    }

    public static void reloadSearchTrees() {
        SearchTreeReloadable searchTree = (SearchTreeReloadable)Minecraft.func_71410_x().func_213253_a(SearchTreeManager.field_215359_a);
        SearchTreeExtender.removeFromTree(searchTree, ItemStack.class);
        SearchTreeExtender.addToTree((SearchTreeReloadable<ItemStack>)searchTree, PokeBallRegistry.getAll(), (T pokeBall) -> {
            ArrayList itemStacks = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)pokeBall.getName(), (Object)pokeBall.getBallItem())});
            if (pokeBall.hasLid()) {
                itemStacks.add(Pair.of((Object)(pokeBall.getName() + "_lid"), (Object)pokeBall.getLidItem()));
            }
            return itemStacks;
        });
        SearchTreeExtender.addToTree((SearchTreeReloadable<ItemStack>)searchTree, Cards.getAll(), (T card) -> Collections.singletonList(Pair.of((Object)card.getTranslatedName().getString(), (Object)card.getItemStack(1))));
        SearchTreeExtender.addToTree(searchTree, new ItemStack((IItemProvider)TCGBlocks.essence_jar), "essence_jar");
        searchTree.func_194040_a();
    }

    public static <T> void addToTree(SearchTreeReloadable<ItemStack> tree, Collection<T> entries, Function<T, List<Pair<String, ItemStack>>> function) {
        for (T entry : entries) {
            for (Pair<String, ItemStack> itemAndName : function.apply(entry)) {
                SearchTreeExtender.addToTree(tree, itemAndName.getSecond(), (String)itemAndName.getFirst());
            }
        }
    }

    private static <T> void addToTree(SearchTreeReloadable<T> tree, T toAdd, String path) {
        if (!tree.field_217879_e.containsKey(toAdd)) {
            ADDED_ITEMS.add(toAdd);
            tree.field_217879_e.put(toAdd, tree.field_217878_d.size());
            tree.field_217878_d.add(toAdd);
            ((Stream)tree.field_217877_c.apply(toAdd)).forEach(id -> {
                tree.field_217875_a.func_194057_a(toAdd, id.func_110624_b().toLowerCase(Locale.ROOT));
                tree.field_217876_b.func_194057_a(toAdd, path.toLowerCase(Locale.ROOT));
            });
        }
    }

    private static <T> void removeFromTree(SearchTreeReloadable<T> tree, Class<T> type) {
        Iterator<Object> iterator = ADDED_ITEMS.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!type.isInstance(object)) continue;
            SearchTreeExtender.removeFromTree(tree, type.cast(object));
            iterator.remove();
        }
    }

    private static <T> void removeFromTree(SearchTreeReloadable<T> tree, T toRemove) {
        tree.field_217879_e.removeInt(toRemove);
        tree.field_217878_d.remove(toRemove);
    }
}

