/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.CursorHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.MaxMoveConverter;
import com.pixelmonmod.pixelmon.battles.attacks.TargetingInfo;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.camera.ChattableCameraScreen;
import com.pixelmonmod.pixelmon.client.gui.EvolveScreen;
import com.pixelmonmod.pixelmon.client.gui.ItemDropsScreen;
import com.pixelmonmod.pixelmon.client.gui.MegaItemScreen;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleBaseScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleLogElement;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.ChooseAttack;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.MegaEvolution;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.old_gui.chooseMove.ChooseEther;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.old_gui.chooseMove.ReplaceAttack;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.old_gui.choosePokemon.ChooseLearnMove;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.ChooseTargets;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.LevelUpScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.WaitingScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.bag.ApplyToPokemon;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.bag.ChooseBag;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.pokemon.ChoosePokemon;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.pokemon.EnforcedRevive;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.pokemon.EnforcedSwitch;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.yesNo.YesNoForfeit;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.yesNo.YesNoReplaceMove;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.OverlayBase;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.OverlayNew;
import com.pixelmonmod.pixelmon.client.gui.widgets.ChatExtensionScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.music.BattleMusic;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BattleGuiClosedPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.RemoveSpectatorPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.gui.GuiBattleUpdatePacket;
import com.pixelmonmod.pixelmon.storage.ClientData;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class BattleScreen
extends ChattableCameraScreen {
    private int guiWidth = 300;
    private int guiHeight = 60;
    public ClientBattleManager bm;
    ArrayList<BattleBaseScreen> screenList = new ArrayList();
    BattleBaseScreen currentScreen = null;
    public OverlayBase pokemonOverlay = null;
    private Button stopSpectateButton = null;
    public BattleLogElement battleLog;
    public boolean showGlobalInfo = true;
    boolean first = true;
    public int mouseOverButton = 0;
    private int shutdownDelay = 0;
    private int tick;

    public BattleScreen() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        player.func_70637_d(false);
        player.func_226284_e_(false);
        player.field_70702_br = 0.0f;
        player.field_191988_bg = 0.0f;
        PixelmonOverlayScreen.isVisible = false;
        this.bm = ClientProxy.battleManager;
        this.battleLog = new BattleLogElement(this.bm);
        this.screenList.add(new ApplyToPokemon(this, BattleMode.APPLY_TO_POKEMON));
        this.screenList.add(new ChooseAttack(this, BattleMode.CHOOSE_ATTACK));
        this.screenList.add(new ChooseBag(this, BattleMode.CHOOSE_BAG));
        this.screenList.add(new ChooseEther(this));
        this.screenList.add(new ChooseLearnMove(this, BattleMode.CHOOSE_RELEARN_MOVE));
        this.screenList.add(new ChooseLearnMove(this, BattleMode.CHOOSE_TUTOR));
        this.screenList.add(new ChoosePokemon(this, BattleMode.CHOOSE_POKEMON));
        this.screenList.add(new ChooseTargets(this, BattleMode.CHOOSE_TARGETS));
        this.screenList.add(new EnforcedRevive(this, BattleMode.ENFORCED_REVIVE));
        this.screenList.add(new EnforcedSwitch(this, BattleMode.ENFORCED_SWITCH));
        this.screenList.add(new LevelUpScreen(this, BattleMode.LEVEL_UP));
        this.screenList.add(new MegaEvolution(this));
        this.screenList.add(new ReplaceAttack(this));
        this.screenList.add(new YesNoForfeit(this));
        this.screenList.add(new YesNoReplaceMove(this));
        this.screenList.add(new WaitingScreen(this, BattleMode.WAITING));
        this.screenList.add(new ChooseAttack(this, BattleMode.MAIN_MENU));
        if (this.bm.teamPokemon != null && this.bm.displayedEnemyPokemon != null) {
            this.pokemonOverlay = new OverlayNew(this);
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.bm.isSpectating) {
            this.addStopSpectateButton();
        }
        for (Screen screen : this.screenList) {
            screen.func_231158_b_(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_);
        }
        if (this.pokemonOverlay instanceof OverlayNew) {
            this.pokemonOverlay.func_231158_b_(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_);
        }
    }

    private void addStopSpectateButton() {
        this.stopSpectateButton = new IndexedButton(0, this.field_230708_k_ / 2 - 50, 0, 100, 20, (ITextComponent)new TranslationTextComponent("gui.spectate.stopspectate"), this::actionPerformed);
        this.func_230480_a_((Widget)this.stopSpectateButton);
    }

    public void restoreSettingsAndClose() {
        BattleScreen.restoreSettingsAndCloseStatic(this.bm);
    }

    public static void restoreSettingsAndCloseStatic(@Nullable ClientBattleManager bm) {
        Minecraft mc = Minecraft.func_71410_x();
        if (bm != null) {
            bm.restoreSettingsAndClose();
        }
        mc.field_71439_g.func_71053_j();
        PixelmonOverlayScreen.isVisible = true;
        if (ServerStorageDisplay.bossDrops != null) {
            mc.func_147108_a((Screen)new ItemDropsScreen());
        } else if (bm != null && !bm.evolveList.isEmpty()) {
            mc.func_147108_a((Screen)new EvolveScreen());
        } else if (ClientData.openMegaItemGui >= 0) {
            mc.func_147108_a((Screen)new MegaItemScreen(ClientData.openMegaItemGui > 0));
        } else {
            NetworkHelper.sendToServer(new BattleGuiClosedPacket());
        }
        BattleMusic.endBattleMusic();
        CursorHelper.setCursor(CursorHelper.DEFAULT_CURSOR);
    }

    @Override
    public void func_231164_f_() {
        super.func_231164_f_();
        if (this.bm.battleEnded && !this.bm.hasNewAttacks()) {
            NetworkHelper.sendToServer(new BattleGuiClosedPacket());
        }
    }

    private void selectScreen() {
        for (BattleBaseScreen bs : this.screenList) {
            if (!bs.isScreen()) continue;
            this.currentScreen = bs;
            break;
        }
    }

    public void selectScreenImmediate(BattleMode mode) {
        this.bm.setMode(mode);
        this.selectScreen();
    }

    private void drawPokemonOverlays(MatrixStack matrix) {
        if (this.pokemonOverlay != null) {
            this.pokemonOverlay.render(matrix, this.field_230708_k_, this.field_230709_l_, this.guiWidth, this.guiHeight);
        }
    }

    public static void drawHealthBar(MatrixStack matrix, int x, int y, int width, int height, float health, int maxHealth) {
        float b;
        float g;
        float r;
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableColorMaterial();
        matrix.func_227860_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.disableTexture();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int barWidth = width - 6;
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_227885_a_(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)(y + height), 0.0).func_227885_a_(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + barWidth), (double)(y + height), 0.0).func_227885_a_(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + barWidth), (double)y, 0.0).func_227885_a_(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        float Percent = health / (float)maxHealth;
        if (Percent > 1.0f) {
            Percent = 1.0f;
        }
        float CurWidth = Percent * (float)barWidth;
        if (health <= (float)maxHealth / 5.0f) {
            r = 0.8f;
            g = 0.0f;
            b = 0.0f;
        } else if (health <= (float)maxHealth / 2.0f) {
            r = 1.0f;
            g = 1.0f;
            b = 0.4f;
        } else {
            r = 0.2f;
            g = 1.0f;
            b = 0.2f;
        }
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)(y + height), 0.0).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)((float)x + CurWidth), (double)(y + height), 0.0).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)((float)x + CurWidth), (double)y, 0.0).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        matrix.func_227865_b_();
        RenderSystem.enableTexture();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableColorMaterial();
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.bm.getMode() == BattleMode.CHOOSE_TARGETS) {
            this.bm.selectedAttack = -1;
            this.bm.setMode(BattleMode.MAIN_MENU);
        }
        if (keyCode == 256 && !this.chat.isChatOpen()) {
            return false;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean func_231042_a_(char key, int keyCode) {
        super.func_231042_a_(key, keyCode);
        if (ChatExtensionScreen.chatOpen || keyCode != 257 || this.bm.hasMoreMessages()) {
            // empty if block
        }
        return false;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        if (this.currentScreen != null) {
            this.currentScreen.click(this.field_230708_k_, this.field_230709_l_, mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_238651_a_(matrix, 0);
        if (this.bm.getMode() != BattleMode.YES_NO_REPLACE_MOVE && !this.bm.hasMoreMessages()) {
            if (this.bm.hasLevelUps()) {
                if (this.bm.getMode() != BattleMode.LEVEL_UP) {
                    this.bm.setMode(BattleMode.LEVEL_UP, this.bm.getMode());
                }
            } else if (this.bm.hasNewAttacks() && this.bm.getMode() != BattleMode.REPLACE_ATTACK) {
                this.bm.setMode(BattleMode.REPLACE_ATTACK, this.bm.getMode());
            }
        }
        this.selectScreen();
        if (this.first) {
            this.first = false;
            if (ClientProxy.camera != null && !this.bm.battleEnded) {
                this.bm.setCameraToPlayer();
            }
        }
        if (this.isBattleComplete()) {
            this.restoreSettingsAndClose();
            return;
        }
        RenderHelper.func_74518_a();
        RenderSystem.enableBlend();
        if (this.bm.getMode() != BattleMode.LEVEL_UP && this.bm.getMode() != BattleMode.REPLACE_ATTACK && this.bm.getMode() != BattleMode.YES_NO_REPLACE_MOVE && (this.bm.getMode() == BattleMode.WAITING || this.bm.getMode() == BattleMode.MAIN_MENU || this.bm.getMode() == BattleMode.CHOOSE_ATTACK || this.bm.getMode() == BattleMode.CHOOSE_TARGETS || this.bm.getMode() == BattleMode.ENFORCED_SWITCH || this.bm.getMode() == BattleMode.ENFORCED_REVIVE)) {
            this.drawPokemonOverlays(matrix);
        }
        if (this.currentScreen != null) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 0.0, 10.0);
            this.currentScreen.render(matrix, this.field_230708_k_, this.field_230709_l_, mouseX, mouseY, partialTicks);
            matrix.func_227865_b_();
        }
        if (this.bm.isSpectating) {
            if (this.stopSpectateButton == null) {
                this.addStopSpectateButton();
            }
            this.stopSpectateButton.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        }
        if (this.bm.afkOn && this.bm.afkTime <= 0) {
            this.bm.afkActive = true;
            this.bm.afkSelectMove();
            this.bm.resetAFKTime();
        }
        if (this.showGlobalInfo && this.bm.battleControllerIndex > -1) {
            ScreenHelper.drawCenteredSquashedString(matrix, this.field_230706_i_.field_71466_p, I18n.func_135052_a((String)"gui.battle.turn", (Object[])new Object[]{this.bm.battleTurn + 1}), false, 75.0, this.field_230708_k_ - 40, this.field_230709_l_ - 69, 0xFFFFFF, false);
            String timeString = this.currentScreen instanceof ChooseAttack ? (this.bm.afkOn ? I18n.func_135052_a((String)"gui.battle.turntimer", (Object[])new Object[]{this.bm.afkTime, this.bm.afkTime == 1 ? "" : "s"}) : I18n.func_135052_a((String)"gui.battle.noturntimer", (Object[])new Object[0])) : "Waiting...";
            ScreenHelper.drawCenteredSquashedString(matrix, this.field_230706_i_.field_71466_p, timeString, false, 75.0, this.field_230708_k_ - 40, this.field_230709_l_ - 53, 0xFFFFFF, false);
            ScreenHelper.drawCenteredSquashedString(matrix, this.field_230706_i_.field_71466_p, this.bm.weather == null ? I18n.func_135052_a((String)"gui.battle.noweather", (Object[])new Object[0]) : this.bm.weather.getLocalizedName(), false, 75.0, this.field_230708_k_ - 40, this.field_230709_l_ - 37, 0xFFFFFF, false);
            ScreenHelper.drawCenteredSquashedString(matrix, this.field_230706_i_.field_71466_p, this.bm.terrain == null ? I18n.func_135052_a((String)"gui.battle.noterrain", (Object[])new Object[0]) : this.bm.terrain.getLocalizedName(), false, 75.0, this.field_230708_k_ - 40, this.field_230709_l_ - 21, 0xFFFFFF, false);
        }
        this.showGlobalInfo = true;
        RenderSystem.disableRescaleNormal();
        RenderHelper.func_74518_a();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        if (Pixelmon.isDevEnvironment() && Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            int centerW = this.field_230708_k_ / 2;
            int centerH = this.field_230709_l_ / 2;
            ScreenHelper.drawCenteredString(matrix, "x: " + mouseX + ", y: " + mouseY, (float)mouseX, (float)(mouseY - 29), 1048575);
            ScreenHelper.drawCenteredString(matrix, "xcenter: " + (mouseX - centerW), (float)mouseX, (float)(mouseY - 19), 1048575);
            ScreenHelper.drawCenteredString(matrix, "ycenter: " + (mouseY - centerH) + ", " + (this.field_230709_l_ - mouseY), (float)mouseX, (float)(mouseY - 9), 1048575);
            ScreenHelper.drawCenteredString(matrix, "width: " + this.field_230708_k_ + ", height: " + this.field_230709_l_, (float)centerW, 20.0f, 1048575);
            ScreenHelper.drawCenteredString(matrix, "mode: " + this.bm.getMode().name(), (float)centerW, 40.0f, 1048575);
        }
    }

    private boolean isBattleComplete() {
        if (!(this.bm.hasMoreMessages() || this.bm.hasMoreTasks() || this.bm.hasLevelUps() || this.bm.hasNewAttacks() || this.bm.choosingPokemon || !this.bm.battleEnded)) {
            ++this.shutdownDelay;
            return this.shutdownDelay > 15;
        }
        this.shutdownDelay = 0;
        return false;
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.currentScreen != null) {
            this.currentScreen.func_231023_e_();
        }
        ++this.tick;
        if (this.tick++ % 100 == 1) {
            NetworkHelper.sendToServer(new GuiBattleUpdatePacket());
        }
    }

    public int getGuiWidth() {
        return this.guiWidth;
    }

    public int getGuiHeight() {
        return this.guiHeight;
    }

    public boolean canSelectTarget(Attack attack) {
        int allyCount;
        AttackCategory attackCategory = attack.getAttackCategory();
        boolean attackHasZMove = attack.getMove().z != null;
        boolean usingZMove = this.bm.showZMoves;
        int enemyCount = this.bm.displayedEnemyPokemon != null ? this.bm.displayedEnemyPokemon.length : 0;
        int ourCount = this.bm.displayedOurPokemon != null ? this.bm.displayedOurPokemon.length : 0;
        int n = allyCount = this.bm.displayedAllyPokemon != null ? this.bm.displayedAllyPokemon.length : 0;
        if (attackCategory != AttackCategory.STATUS && attackHasZMove && usingZMove && (enemyCount > 1 || ourCount > 1 || allyCount > 0)) {
            return true;
        }
        if ((attackCategory != AttackCategory.STATUS && this.bm.dynamaxing || this.bm.dynamax != null) && (enemyCount > 1 || ourCount > 1 || allyCount > 0)) {
            return true;
        }
        if (attack.getMove().getFlags().nontarget) {
            return false;
        }
        TargetingInfo info = attack.getMove().getTargetingInfo();
        if (info.hitsAll) {
            return false;
        }
        if (info.hitsSelf && info.hitsAdjacentAlly && this.bm.teamPokemon.length > 1) {
            return true;
        }
        if (!info.hitsSelf && !info.hitsAdjacentFoe && this.bm.teamPokemon.length == 1) {
            return false;
        }
        if (attack.isAttack(AttackRegistry.CURSE) && !this.bm.getCurrentPokemon().getBaseStats().getTypes().contains(Element.GHOST)) {
            return false;
        }
        return !info.hitsSelf && (this.bm.teamPokemon.length > 1 || this.bm.displayedEnemyPokemon.length > 1);
    }

    public boolean setTargeting(PixelmonClientData pig, Attack attack, int opponentTarget, int userTarget) {
        if (this.bm.dynamaxing || pig.pokemonUUID.equals(this.bm.dynamax)) {
            attack = pig.gmaxFactor ? MaxMoveConverter.getGMaxMoveFromAttack(attack, null, pig.species, pig.species.getForm(pig.form)) : MaxMoveConverter.getMaxMoveFromAttack(attack, null);
        }
        for (int i = 0; i < this.bm.targetted.length; ++i) {
            for (int j = 0; j < this.bm.targetted[i].length; ++j) {
                this.bm.targetted[i][j] = false;
            }
        }
        TargetingInfo info = attack.getMove().getTargetingInfo();
        AttackCategory attackCategory = attack.getAttackCategory();
        boolean attackHasZMove = attack.getMove().z != null;
        boolean usingZMove = this.bm.showZMoves;
        if (attackCategory != AttackCategory.STATUS && attackHasZMove && usingZMove) {
            boolean canSelectTarget = this.setDamagingZMoveTargeting(attack, info, opponentTarget, userTarget);
            if (!canSelectTarget) {
                return false;
            }
        } else if (info.hitsAll) {
            this.setHitsAllTargeting(info);
        } else {
            if (userTarget != -1) {
                this.setHitsAlliedTeamTargeting(info, userTarget);
            }
            if (opponentTarget != -1) {
                this.setHitsOpponentTeamTargeting(info, opponentTarget);
            }
            if (userTarget == -1 && opponentTarget == -1) {
                boolean isCurseUser;
                boolean bl = isCurseUser = attack.isAttack(AttackRegistry.CURSE) && !this.bm.getCurrentPokemon().getBaseStats().getTypes().contains(Element.GHOST);
                if (info.hitsSelf || isCurseUser) {
                    this.bm.targetted[0][this.bm.currentPokemon] = true;
                } else if (info.hitsOppositeFoe && this.bm.currentPokemon < this.bm.targetted[1].length) {
                    this.bm.targetted[1][this.bm.currentPokemon] = true;
                }
            }
        }
        if (userTarget >= 0) {
            return this.bm.targetted[0].length > userTarget && this.bm.targetted[0][userTarget];
        }
        if (opponentTarget >= 0) {
            return this.bm.targetted[1].length > opponentTarget && this.bm.targetted[1][opponentTarget];
        }
        return false;
    }

    private boolean setDamagingZMoveTargeting(Attack attack, TargetingInfo info, int opponentTarget, int userTarget) {
        if (opponentTarget == -1 && userTarget == -1 && !attack.isAttack(AttackRegistry.LAST_RESORT) && info.hitsOppositeFoe && this.bm.currentPokemon < this.bm.targetted[1].length) {
            this.bm.targetted[1][this.bm.currentPokemon] = true;
            return false;
        }
        if (attack.isAttack(AttackRegistry.LAST_RESORT)) {
            if (opponentTarget == -1 && userTarget == -1) {
                this.bm.targetted[0][this.bm.currentPokemon] = true;
            } else if (userTarget != -1 && userTarget == this.bm.currentPokemon) {
                this.bm.targetted[0][this.bm.currentPokemon] = true;
            }
        }
        if (opponentTarget != -1) {
            if (opponentTarget == this.bm.currentPokemon) {
                this.bm.targetted[1][this.bm.currentPokemon] = true;
            }
            if (opponentTarget == this.bm.currentPokemon + 1) {
                this.bm.targetted[1][this.bm.currentPokemon + 1] = true;
            }
            if (opponentTarget == this.bm.currentPokemon - 1) {
                this.bm.targetted[1][this.bm.currentPokemon - 1] = true;
            }
        }
        if (attack.isAttack(AttackRegistry.CLANGING_SCALES)) {
            if (this.bm.currentPokemon < this.bm.targetted[1].length) {
                this.bm.targetted[1][this.bm.currentPokemon] = true;
            }
            if (this.bm.currentPokemon - 1 >= 0 && this.bm.currentPokemon - 1 < this.bm.targetted[1].length) {
                this.bm.targetted[1][this.bm.currentPokemon - 1] = true;
            }
            if (this.bm.currentPokemon + 1 < this.bm.targetted[1].length) {
                this.bm.targetted[1][this.bm.currentPokemon + 1] = true;
            }
        } else if (userTarget != -1) {
            if (userTarget == this.bm.currentPokemon + 1) {
                this.bm.targetted[0][this.bm.currentPokemon + 1] = true;
            }
            if (userTarget == this.bm.currentPokemon - 1) {
                this.bm.targetted[0][this.bm.currentPokemon - 1] = true;
            }
            if (userTarget == this.bm.currentPokemon) {
                this.bm.targetted[0][this.bm.currentPokemon] = true;
            }
        }
        return true;
    }

    private void setHitsAllTargeting(TargetingInfo info) {
        if (info.hitsOppositeFoe && this.bm.currentPokemon < this.bm.targetted[1].length) {
            this.bm.targetted[1][this.bm.currentPokemon] = true;
        }
        if (info.hitsAdjacentFoe) {
            if (this.bm.currentPokemon - 1 >= 0 && this.bm.currentPokemon - 1 < this.bm.targetted[1].length) {
                this.bm.targetted[1][this.bm.currentPokemon - 1] = true;
            }
            if (this.bm.currentPokemon + 1 < this.bm.targetted[1].length) {
                this.bm.targetted[1][this.bm.currentPokemon + 1] = true;
            }
        }
        if (info.hitsExtendedFoe) {
            if (this.bm.currentPokemon - 2 >= 0 && this.bm.currentPokemon - 2 < this.bm.targetted[1].length) {
                this.bm.targetted[1][this.bm.currentPokemon - 2] = true;
            }
            if (this.bm.currentPokemon + 2 < this.bm.targetted[1].length) {
                this.bm.targetted[1][this.bm.currentPokemon + 2] = true;
            }
        }
        if (info.hitsSelf) {
            this.bm.targetted[0][this.bm.currentPokemon] = true;
        }
        if (info.hitsAdjacentAlly) {
            if (this.bm.currentPokemon - 1 >= 0) {
                this.bm.targetted[0][this.bm.currentPokemon - 1] = true;
            }
            if (this.bm.currentPokemon + 1 < this.bm.targetted[0].length) {
                this.bm.targetted[0][this.bm.currentPokemon + 1] = true;
            }
        }
        if (info.hitsExtendedAlly) {
            if (this.bm.currentPokemon - 2 >= 0) {
                this.bm.targetted[0][this.bm.currentPokemon - 2] = true;
            }
            if (this.bm.currentPokemon + 2 < this.bm.targetted[0].length) {
                this.bm.targetted[0][this.bm.currentPokemon + 2] = true;
            }
        }
    }

    private void setHitsAlliedTeamTargeting(TargetingInfo info, int userTarget) {
        if (userTarget == this.bm.currentPokemon && info.hitsSelf) {
            this.bm.targetted[0][this.bm.currentPokemon] = true;
        }
        if (info.hitsAdjacentAlly) {
            if (userTarget == this.bm.currentPokemon + 1) {
                this.bm.targetted[0][this.bm.currentPokemon + 1] = true;
            }
            if (userTarget == this.bm.currentPokemon - 1) {
                this.bm.targetted[0][this.bm.currentPokemon - 1] = true;
            }
        }
        if (info.hitsExtendedAlly) {
            if (userTarget == this.bm.currentPokemon + 2) {
                this.bm.targetted[0][this.bm.currentPokemon + 2] = true;
            }
            if (userTarget == this.bm.currentPokemon - 2) {
                this.bm.targetted[0][this.bm.currentPokemon - 2] = true;
            }
        }
    }

    private void setHitsOpponentTeamTargeting(TargetingInfo info, int opponentTarget) {
        if (this.bm.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.HORDE || this.bm.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.RAID) {
            for (int i = 0; i < this.bm.targetted[1].length; ++i) {
                if (i != opponentTarget) continue;
                this.bm.targetted[1][i] = true;
            }
        }
        if (info.hitsOppositeFoe && opponentTarget == this.bm.currentPokemon) {
            this.bm.targetted[1][this.bm.currentPokemon] = true;
        }
        if (info.hitsAdjacentFoe) {
            if (opponentTarget == this.bm.currentPokemon + 1) {
                this.bm.targetted[1][this.bm.currentPokemon + 1] = true;
            }
            if (opponentTarget == this.bm.currentPokemon - 1) {
                this.bm.targetted[1][this.bm.currentPokemon - 1] = true;
            }
        }
        if (info.hitsExtendedFoe) {
            if (opponentTarget == this.bm.currentPokemon + 2) {
                this.bm.targetted[1][this.bm.currentPokemon + 2] = true;
            }
            if (opponentTarget == this.bm.currentPokemon - 2) {
                this.bm.targetted[1][this.bm.currentPokemon - 2] = true;
            }
        }
    }

    public boolean isTargeted(UUID uuid) {
        int i;
        for (i = 0; i < this.bm.teamPokemon.length; ++i) {
            if (!Objects.equals(this.bm.teamPokemon[i], uuid)) continue;
            return this.bm.targetted[0].length > i && this.bm.targetted[0][i];
        }
        for (i = 0; i < this.bm.displayedEnemyPokemon.length; ++i) {
            if (!Objects.equals(this.bm.displayedEnemyPokemon[i].pokemonUUID, uuid)) continue;
            return this.bm.targetted[1].length > i && this.bm.targetted[1][i];
        }
        return false;
    }

    public boolean showTargeting() {
        return this.bm.teamPokemon.length != 1 || this.bm.displayedEnemyPokemon.length != 1;
    }

    protected void actionPerformed(Button button) {
        if (button == this.stopSpectateButton) {
            this.bm.endSpectate();
            NetworkHelper.sendToServer(new RemoveSpectatorPacket(this.bm.battleControllerIndex, this.field_230706_i_.field_71439_g.func_110124_au()));
        }
    }

    public void func_231152_a_(Minecraft mc, int w, int h) {
        super.func_231152_a_(mc, w, h);
        for (Screen screen : this.screenList) {
            screen.func_231152_a_(mc, w, h);
        }
        if (this.pokemonOverlay != null) {
            this.pokemonOverlay.func_231152_a_(mc, this.field_230708_k_, this.field_230709_l_);
        }
    }
}

