/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.camera.CameraEntity;
import com.pixelmonmod.pixelmon.client.camera.CameraMode;
import com.pixelmonmod.pixelmon.client.camera.CameraScreen;
import com.pixelmonmod.pixelmon.client.camera.CameraTargetEntity;
import com.pixelmonmod.pixelmon.client.gui.ItemDropsScreen;
import com.pixelmonmod.pixelmon.client.gui.MegaItemScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.EvoInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BattleGuiClosedPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionResponsePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.storage.ClientData;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class EvolveScreen
extends CameraScreen {
    public static PixelmonEntity currentPokemon;
    boolean createdEntity = false;
    String newPokemon;
    String oldNickname;
    boolean cancelled = false;
    EvoInfo evoInfo = null;
    int ticks = 0;
    int fadeCount = 0;

    public EvolveScreen() {
        super(CameraMode.Evolution);
        if (this.field_230706_i_ == null) {
            this.field_230706_i_ = Minecraft.func_71410_x();
        }
        if (ClientProxy.battleManager.evolveList.isEmpty()) {
            this.field_230706_i_.field_71439_g.func_71053_j();
            return;
        }
        this.field_230706_i_.func_212871_a_(() -> {
            this.checkForPokemon();
            if (currentPokemon == null) {
                NetworkHelper.sendToServer(new EvolutionResponsePacket(this.evoInfo.pokemonUUID));
            }
        });
    }

    private void checkForPokemon() {
        if (ClientProxy.battleManager.evolveList.isEmpty() && this.evoInfo == null) {
            return;
        }
        if (this.evoInfo == null) {
            this.evoInfo = ClientProxy.battleManager.evolveList.get(0);
            ClientProxy.battleManager.evolveList.remove(0);
        }
        UUID pokemonUUID = this.evoInfo.pokemonUUID;
        this.newPokemon = this.evoInfo.evolveInto;
        currentPokemon = ScreenHelper.getEntity(pokemonUUID);
        Minecraft mc = Minecraft.func_71410_x();
        if (currentPokemon == null) {
            return;
        }
        EvolveScreen.currentPokemon.field_70714_bg.field_220892_d.clear();
        if (ClientProxy.camera != null && PixelmonConfigProxy.getGraphics().isUseBattleCamera()) {
            ClientProxy.camera.revive();
            ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)currentPokemon));
            mc.func_175607_a((Entity)ClientProxy.camera);
        } else {
            Entity renderEntity = Minecraft.func_71410_x().func_175606_aa();
            ClientProxy.camera = new CameraEntity(EvolveScreen.currentPokemon.field_70170_p);
            this.getCamera().revive();
            this.getCamera().func_70107_b(renderEntity.func_226277_ct_(), renderEntity.func_226278_cu_() + 2.0, renderEntity.func_226281_cx_());
            this.getCamera().field_70177_z = renderEntity.field_70177_z;
            this.getCamera().field_70125_A = renderEntity.field_70125_A;
            this.getCamera().field_70759_as = renderEntity.func_70079_am();
            ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)currentPokemon));
            ClientProxy.camera.getMovement().generatePositions();
            this.field_230706_i_.field_71441_e.func_217411_a(ClientProxy.camera.func_145782_y(), (Entity)ClientProxy.camera);
        }
        this.oldNickname = currentPokemon.getNickname();
        this.calcSizeDifference();
    }

    private void calcSizeDifference() {
        Stats bs = PixelmonSpecies.fromName(this.newPokemon).getValueUnsafe().getDefaultForm();
        Stats currentStats = currentPokemon.getForm();
        if (currentStats == null) {
            return;
        }
        Dimensions newData = bs.getDimensions();
        Dimensions currentData = currentPokemon.getForm().getDimensions();
        EvolveScreen.currentPokemon.heightDiff = (float)(newData.getHeight() - currentData.getHeight());
        EvolveScreen.currentPokemon.widthDiff = (float)(newData.getWidth() - currentData.getWidth());
        EvolveScreen.currentPokemon.lengthDiff = (float)(newData.getWidth() - currentData.getWidth());
    }

    @Override
    public void func_231165_f_(int par1) {
    }

    public void func_230446_a_(MatrixStack matrix) {
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (currentPokemon != null && currentPokemon.getEvoStage() == EvolutionStage.Choice) {
            ++this.ticks;
            if (this.ticks >= 80) {
                NetworkHelper.sendToServer(new EvolutionResponsePacket(currentPokemon.getPokemon().getUUID(), true));
                EvolveScreen.currentPokemon.evolvingVal = 0;
                EvolveScreen.currentPokemon.evoAnimTicks = 0;
                this.ticks = 0;
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int par3) {
        if (currentPokemon == null) {
            return false;
        }
        if (currentPokemon.getEvoStage() == EvolutionStage.Choice) {
            int xPos = this.field_230708_k_ / 2 - 30;
            int yPos = this.field_230709_l_ / 4 - 15;
            if (mouseX >= (double)xPos && mouseX <= (double)(xPos + 60) && mouseY >= (double)yPos && mouseY <= (double)(yPos + 17)) {
                NetworkHelper.sendToServer(new EvolutionResponsePacket(currentPokemon.getPokemon().getUUID(), false));
                currentPokemon.setEvoStage(null);
                this.cancelled = true;
            }
        } else if (!currentPokemon.isEvolving() || this.cancelled) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.field_71439_g.func_71053_j();
            if (!ClientProxy.battleManager.evolveList.isEmpty()) {
                minecraft.func_147108_a((Screen)new EvolveScreen());
            } else if (ServerStorageDisplay.bossDrops != null) {
                minecraft.func_147108_a((Screen)new ItemDropsScreen());
            } else if (!ClientProxy.battleManager.newAttackList.isEmpty()) {
                minecraft.func_147108_a((Screen)new BattleScreen());
            } else if (ClientData.openMegaItemGui >= 0) {
                minecraft.func_147108_a((Screen)new MegaItemScreen(ClientData.openMegaItemGui > 0));
            } else {
                NetworkHelper.sendToServer(new BattleGuiClosedPacket());
            }
            minecraft.func_175607_a((Entity)minecraft.field_71439_g);
        }
        return true;
    }

    @Override
    public void func_231164_f_() {
        super.func_231164_f_();
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        String s;
        if (this.field_230706_i_ == null) {
            this.field_230706_i_ = Minecraft.func_71410_x();
        }
        if (currentPokemon == null) {
            this.checkForPokemon();
            return;
        }
        if (currentPokemon.getEvoStage() != EvolutionStage.PreAnimation && currentPokemon.getEvoStage() != EvolutionStage.PostAnimation) {
            ScreenHelper.drawImageQuad(Resources.evo, matrix, (float)this.field_230708_k_ / 2.0f - 120.0f, (float)this.field_230709_l_ / 4.0f - 40.0f, 240.0f, 40.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
        if (currentPokemon.getEvoStage() == EvolutionStage.PreChoice) {
            s = I18n.func_135052_a((String)"gui.guiEvolve.huh", (Object[])new Object[0]);
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, s, (float)this.field_230708_k_ / 2.0f - (float)this.field_230706_i_.field_71466_p.func_78256_a(s) / 2.0f, (float)this.field_230709_l_ / 4.0f - 30.0f, 0xFFFFFF);
        }
        if (currentPokemon.getEvoStage() == EvolutionStage.Choice) {
            this.oldNickname = currentPokemon.getEscapedNickname();
            s = I18n.func_135052_a((String)"gui.guiEvolve.evolve", (Object[])new Object[]{this.oldNickname});
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, s, (float)this.field_230708_k_ / 2.0f - (float)this.field_230706_i_.field_71466_p.func_78256_a(s) / 2.0f, (float)this.field_230709_l_ / 4.0f - 30.0f, 0xFFFFFF);
            int xPos = this.field_230708_k_ / 2 - 30;
            int yPos = this.field_230709_l_ / 4 - 15;
            ResourceLocation rl = mouseX >= xPos && mouseX <= xPos + 60 && mouseY >= yPos && mouseY <= yPos + 17 ? Resources.buttonOver : Resources.button;
            ScreenHelper.drawImageQuad(rl, matrix, xPos, yPos, 60.0f, 17.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            s = I18n.func_135052_a((String)"gui.cancel.text", (Object[])new Object[0]);
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, s, (float)this.field_230708_k_ / 2.0f - (float)this.field_230706_i_.field_71466_p.func_78256_a(s) / 2.0f, (float)this.field_230709_l_ / 4.0f - 11.0f, 0xFFFFFF);
        }
        if (this.cancelled) {
            s = I18n.func_135052_a((String)"gui.guiEvolve.cancel", (Object[])new Object[0]);
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, s, (float)this.field_230708_k_ / 2.0f - (float)this.field_230706_i_.field_71466_p.func_78256_a(s) / 2.0f, (float)this.field_230709_l_ / 4.0f - 30.0f, 0xFFFFFF);
        } else if (!currentPokemon.isEvolving()) {
            s = I18n.func_135052_a((String)"gui.guiEvolve.done", (Object[])new Object[]{this.oldNickname, currentPokemon.getLocalizedName()});
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, s, (float)this.field_230708_k_ / 2.0f - (float)this.field_230706_i_.field_71466_p.func_78256_a(s) / 2.0f, (float)this.field_230709_l_ / 4.0f - 30.0f, 0xFFFFFF);
        }
        this.func_238651_a_(matrix, 0);
    }

    public boolean func_231178_ax__() {
        return false;
    }
}

