/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorkingScreen;
import net.minecraft.client.resources.DownloadingPackFinder;
import net.minecraft.client.resources.ResourceIndex;
import net.minecraft.resources.FilePack;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.util.HTTPUtil;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PixelmonDownloadingPackFinder
extends DownloadingPackFinder {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final FileFilter RESOURCE_PACK_FILTER = p_accept_1_ -> {
        boolean flag = p_accept_1_.isFile() && p_accept_1_.getName().endsWith(".zip");
        boolean flag1 = p_accept_1_.isDirectory() && new File(p_accept_1_, "pack.mcmeta").isFile();
        return flag || flag1;
    };
    private static final Pattern PATTERN_SHA1 = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final ResourceLocation UNKNOWN_PACK_TEXTURE = ResourceLocationHelper.of("textures/misc/unknown_pack.png");
    private final File serverPackDir;
    private final ReentrantLock lockDownload = new ReentrantLock();
    private final ResourceIndex resourceIndex;
    @Nullable
    private CompletableFuture<?> currentDownload;
    @Nullable
    private ResourcePackInfo serverPack;

    public PixelmonDownloadingPackFinder(File serverPackDirIn, ResourceIndex resourceIndexIn) {
        super(serverPackDirIn, resourceIndexIn);
        this.serverPackDir = serverPackDirIn;
        this.resourceIndex = resourceIndexIn;
    }

    public static Map<String, String> getPackDownloadRequestProperties() {
        HashMap map = Maps.newHashMap();
        map.put("X-Minecraft-Username", Minecraft.func_71410_x().func_110432_I().func_111285_a());
        map.put("X-Minecraft-UUID", Minecraft.func_71410_x().func_110432_I().func_148255_b());
        map.put("X-Minecraft-Version", SharedConstants.func_215069_a().getName());
        map.put("X-Minecraft-Version-ID", SharedConstants.func_215069_a().getId());
        map.put("X-Minecraft-Pack-Format", String.valueOf(SharedConstants.func_215069_a().getPackVersion()));
        map.put("User-Agent", "Minecraft Java/" + SharedConstants.func_215069_a().getName());
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> func_217818_a(String url, String hash) {
        CompletableFuture<?> completablefuture1;
        String s = DigestUtils.sha1Hex((String)url);
        String s1 = PATTERN_SHA1.matcher(hash).matches() ? hash : "";
        this.lockDownload.lock();
        try {
            CompletableFuture completablefuture;
            this.func_195749_c();
            this.clearDownloads();
            File file1 = new File(this.serverPackDir, s);
            if (file1.exists()) {
                completablefuture = CompletableFuture.completedFuture("");
            } else {
                WorkingScreen workingscreen = new WorkingScreen();
                Map<String, String> map = PixelmonDownloadingPackFinder.getPackDownloadRequestProperties();
                Minecraft minecraft = Minecraft.func_71410_x();
                minecraft.func_213167_f(() -> minecraft.func_147108_a((Screen)workingscreen));
                completablefuture = HTTPUtil.func_180192_a((File)file1, (String)url, map, (int)0x4B000000, (IProgressUpdate)workingscreen, (Proxy)minecraft.func_110437_J());
            }
            completablefuture1 = this.currentDownload = ((CompletableFuture)completablefuture.thenCompose(p_217812_3_ -> !this.checkHash(s1, file1) ? Util.func_215087_a((Throwable)new RuntimeException("Hash check failure for file " + file1 + ", see log")) : this.func_217816_a(file1, IPackNameDecorator.field_232628_d_))).whenComplete((p_217815_1_, p_217815_2_) -> {
                if (p_217815_2_ != null) {
                    LOGGER.warn("Pack application failed: {}, deleting file {}", (Object)p_217815_2_.getMessage(), (Object)file1);
                    PixelmonDownloadingPackFinder.deleteQuiet(file1);
                }
            });
        }
        finally {
            this.lockDownload.unlock();
        }
        return completablefuture1;
    }

    private static void deleteQuiet(File fileIn) {
        try {
            Files.delete(fileIn.toPath());
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to delete file {}: {}", (Object)fileIn, (Object)ioexception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkHash(String expectedHash, File fileIn) {
        try (FileInputStream fileinputstream = new FileInputStream(fileIn);){
            String s = DigestUtils.sha1Hex((InputStream)fileinputstream);
            if (expectedHash.isEmpty()) {
                LOGGER.info("Found file {} without verification hash", (Object)fileIn);
                boolean bl = true;
                return bl;
            }
            if (s.toLowerCase(Locale.ROOT).equals(expectedHash.toLowerCase(Locale.ROOT))) {
                LOGGER.info("Found file {} matching requested hash {}", (Object)fileIn, (Object)expectedHash);
                boolean bl = true;
                return bl;
            }
            LOGGER.warn("File {} had wrong hash (expected {}, found {}).", (Object)fileIn, (Object)expectedHash, (Object)s);
            return false;
        }
        catch (IOException ioexception) {
            LOGGER.warn("File {} couldn't be hashed.", (Object)fileIn, (Object)ioexception);
        }
        return false;
    }

    private void clearDownloads() {
        try {
            ArrayList list = Lists.newArrayList((Iterable)FileUtils.listFiles((File)this.serverPackDir, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)null));
            list.sort(LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            int i = 0;
            for (File file1 : list) {
                if (i++ < 10) continue;
                LOGGER.info("Deleting old server resource pack {}", (Object)file1.getName());
                FileUtils.deleteQuietly((File)file1);
            }
        }
        catch (IllegalArgumentException illegalargumentexception) {
            LOGGER.error("Error while deleting old server resource pack : {}", (Object)illegalargumentexception.getMessage());
        }
    }

    @Nullable
    private ResourcePackInfo createProgrammerArtPack(ResourcePackInfo.IFactory p_239453_1_) {
        File file2;
        ResourcePackInfo resourcepackinfo = null;
        File file1 = this.resourceIndex.func_188547_a(ResourceLocationHelper.of("resourcepacks/programmer_art.zip"));
        if (file1 != null && file1.isFile()) {
            resourcepackinfo = PixelmonDownloadingPackFinder.createProgrammerArtPack(p_239453_1_, () -> PixelmonDownloadingPackFinder.createProgrammerArtZipPack(file1));
        }
        if (resourcepackinfo == null && SharedConstants.field_206244_b && (file2 = this.resourceIndex.func_225638_a_("../resourcepacks/programmer_art")) != null && file2.isDirectory()) {
            resourcepackinfo = PixelmonDownloadingPackFinder.createProgrammerArtPack(p_239453_1_, () -> PixelmonDownloadingPackFinder.createProgrammerArtDirPack(file2));
        }
        return resourcepackinfo;
    }

    @Nullable
    private static ResourcePackInfo createProgrammerArtPack(ResourcePackInfo.IFactory p_239454_0_, Supplier<IResourcePack> p_239454_1_) {
        return ResourcePackInfo.func_195793_a((String)"programer_art", (boolean)false, p_239454_1_, (ResourcePackInfo.IFactory)p_239454_0_, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP, (IPackNameDecorator)IPackNameDecorator.field_232626_b_);
    }

    private static FolderPack createProgrammerArtDirPack(File p_239459_0_) {
        return new FolderPack(p_239459_0_){

            public String func_195762_a() {
                return "Programmer Art";
            }
        };
    }

    private static IResourcePack createProgrammerArtZipPack(File p_239460_0_) {
        return new FilePack(p_239460_0_){

            public String func_195762_a() {
                return "Programmer Art";
            }
        };
    }
}

