/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.PokeStopEvent;
import com.pixelmonmod.pixelmon.api.util.LootClaim;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.world.generation.loot.LootTableRegistration;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;

public class PokeStopTileEntity
extends TileEntity {
    private boolean oneTimeUse = false;
    private ResourceLocation lootTable = LootTableRegistration.COMMON_POKESTOP;
    private Color color = new Color(101, 217, 253, 255);
    private Color cooldownColor = Color.RED;
    private float scale = 3.0f;
    private final List<LootClaim> claimed = new ArrayList<LootClaim>();

    public PokeStopTileEntity() {
        super((TileEntityType)TileEntityRegistration.POKESTOP.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("PokeStopOneTimeUse", this.oneTimeUse);
        tag.func_74778_a("PokeStopLootTable", this.lootTable.toString());
        tag.func_74768_a("PokeStopColorRed", this.color.getRed());
        tag.func_74768_a("PokeStopColorGreen", this.color.getGreen());
        tag.func_74768_a("PokeStopColorBlue", this.color.getBlue());
        tag.func_74768_a("PokeStopColorAlpha", this.color.getAlpha());
        tag.func_74768_a("PokeStopCooldownColorRed", this.cooldownColor.getRed());
        tag.func_74768_a("PokeStopCooldownColorGreen", this.cooldownColor.getGreen());
        tag.func_74768_a("PokeStopCooldownColorBlue", this.cooldownColor.getBlue());
        tag.func_74768_a("PokeStopCooldownColorAlpha", this.cooldownColor.getAlpha());
        tag.func_74776_a("PokeStopScale", this.scale);
        if (!this.claimed.isEmpty()) {
            ListNBT list = new ListNBT();
            for (int i = 0; i < this.claimed.size(); ++i) {
                CompoundNBT playerInfoTag = new CompoundNBT();
                LootClaim playerClaim = this.claimed.get(i);
                if (this.canClaim(playerClaim.getPlayerID())) continue;
                playerInfoTag.func_186854_a("Claimer", playerClaim.getPlayerID());
                playerInfoTag.func_74772_a("PokeStopTimeClaimed", playerClaim.getTimeClaimed());
                list.add((Object)playerInfoTag);
            }
            tag.func_218657_a("PokeStopClaimedPlayers", (INBT)list);
        }
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        this.oneTimeUse = tag.func_74767_n("PokeStopOneTimeUse");
        this.lootTable = ResourceLocationHelper.of(tag.func_74779_i("PokeStopLootTable"));
        this.color = new Color(tag.func_74762_e("PokeStopColorRed"), tag.func_74762_e("PokeStopColorGreen"), tag.func_74762_e("PokeStopColorBlue"), tag.func_74762_e("PokeStopColorAlpha"));
        this.cooldownColor = new Color(tag.func_74762_e("PokeStopCooldownColorRed"), tag.func_74762_e("PokeStopCooldownColorGreen"), tag.func_74762_e("PokeStopCooldownColorBlue"), tag.func_74762_e("PokeStopCooldownColorAlpha"));
        this.scale = tag.func_74760_g("PokeStopScale");
        if (tag.func_74764_b("PokeStopClaimedPlayers")) {
            ListNBT claimedTag = tag.func_150295_c("PokeStopClaimedPlayers", 10);
            for (INBT inbt : claimedTag) {
                CompoundNBT nbt = (CompoundNBT)inbt;
                this.claimed.add(new LootClaim(nbt.func_186857_a("Claimer"), nbt.func_74763_f("PokeStopTimeClaimed")));
            }
        }
        super.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        return this.func_189515_b(nbt);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(Minecraft.func_71410_x().field_71441_e.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    public boolean canClaim(PlayerEntity player) {
        LootClaim claim = this.getLootClaim(player.func_110124_au());
        PokeStopEvent.CooldownCheck.PreCalculate cooldownCheckPreCalculate = new PokeStopEvent.CooldownCheck.PreCalculate(player, this, PixelmonConfigProxy.getSpawning().getPokeStop().getLootTime());
        if (Pixelmon.EVENT_BUS.post((Event)cooldownCheckPreCalculate)) {
            return false;
        }
        if (claim != null) {
            if (!this.oneTimeUse && (System.currentTimeMillis() - claim.getTimeClaimed()) / 1000L > cooldownCheckPreCalculate.getCooldownHours() * 3600L) {
                this.removeClaimer(player.func_110124_au());
                return true;
            }
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean canClaim(UUID playerID) {
        LootClaim claim = this.getLootClaim(playerID);
        if (claim != null) {
            if (!this.oneTimeUse) {
                return (System.currentTimeMillis() - claim.getTimeClaimed()) / 1000L > (long)PixelmonConfigProxy.getSpawning().getPokeStop().getLootTime() * 3600L;
            }
            return false;
        }
        return true;
    }

    public LootClaim getLootClaim(PlayerEntity player) {
        return this.getLootClaim(player.func_110124_au());
    }

    public LootClaim getLootClaim(UUID playerID) {
        for (LootClaim claim : this.claimed) {
            if (!claim.getPlayerID().equals(playerID)) continue;
            return claim;
        }
        return null;
    }

    public void addClaimer(UUID playerID) {
        this.claimed.add(new LootClaim(playerID, System.currentTimeMillis()));
    }

    public void removeClaimer(UUID playerID) {
        this.claimed.remove(this.getLootClaim(playerID));
    }

    public void setOneTimeUse(boolean oneTimeUse) {
        this.oneTimeUse = oneTimeUse;
    }

    public boolean isOneTimeUse() {
        return this.oneTimeUse;
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public PokeStopTileEntity setLootTable(ResourceLocation lootTable) {
        this.lootTable = lootTable;
        return this;
    }

    public float getScale() {
        return this.scale;
    }

    public PokeStopTileEntity setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public PokeStopTileEntity setColor(Color color) {
        this.color = color;
        return this;
    }

    public Color getCooldownColor() {
        return this.cooldownColor;
    }

    public PokeStopTileEntity setCooldownColor(Color cooldownColor) {
        this.cooldownColor = cooldownColor;
        return this;
    }
}

