/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.util.LootClaim;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileentity.EnumPokegiftType;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Util;

public class PokeGiftTileEntity
extends TileEntity {
    private EnumPokechestVisibility visibility = EnumPokechestVisibility.Visible;
    private UUID ownerID = null;
    private boolean chestOneTime = true;
    private boolean dropOneTime = true;
    private Pokemon pokemon = null;
    private List<PokemonSpecification> specialPixelmon = new ArrayList<PokemonSpecification>();
    private EnumPokegiftType type = EnumPokegiftType.GIFT;
    private List<LootClaim> claimed = new ArrayList<LootClaim>();

    public PokeGiftTileEntity() {
        super((TileEntityType)TileEntityRegistration.POKE_GIFT.get());
    }

    public void setOwner(UUID id) {
        this.ownerID = id;
    }

    public UUID getOwner() {
        return this.ownerID;
    }

    public void setType(EnumPokegiftType t) {
        this.type = t;
    }

    public EnumPokegiftType getGiftType() {
        return this.type;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ListNBT list;
        super.func_189515_b(compound);
        compound.func_186854_a("Owner", this.ownerID == null ? Util.field_240973_b_ : this.ownerID);
        compound.func_74757_a("chestOneTime", this.chestOneTime);
        compound.func_74757_a("dropOneTime", this.dropOneTime);
        compound.func_74768_a("type", this.type.ordinal());
        if (!this.claimed.isEmpty()) {
            list = new ListNBT();
            for (int i = 0; i < this.claimed.size(); ++i) {
                CompoundNBT playerInfoTag = new CompoundNBT();
                LootClaim playerClaim = this.claimed.get(i);
                playerInfoTag.func_186854_a("most", playerClaim.getPlayerID());
                playerInfoTag.func_74772_a("timeClaimed", playerClaim.getTimeClaimed());
                list.add((Object)playerInfoTag);
            }
            compound.func_218657_a("claimedPlayers", (INBT)list);
        }
        if (this.type == EnumPokegiftType.GIFT) {
            if (this.pokemon != null) {
                CompoundNBT pokemon = new CompoundNBT();
                this.pokemon.writeToNBT(pokemon);
                compound.func_218657_a("pixelmon", (INBT)pokemon);
            }
        } else if (!this.specialPixelmon.isEmpty()) {
            list = new ListNBT();
            for (PokemonSpecification p : this.specialPixelmon) {
                CompoundNBT nbt = new CompoundNBT();
                p.write(nbt);
                list.add((Object)nbt);
            }
            compound.func_218657_a("specials", (INBT)list);
        }
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagger) {
        CompoundNBT nbt;
        ListNBT claimedTag;
        UUID uuid = tagger.func_186857_a("Owner");
        this.ownerID = Objects.equals(Util.field_240973_b_, uuid) ? null : uuid;
        this.chestOneTime = tagger.func_74767_n("chestOneTime");
        this.dropOneTime = tagger.func_74767_n("dropOneTime");
        this.type = EnumPokegiftType.values()[tagger.func_74762_e("type")];
        if (tagger.func_74764_b("claimedPlayers")) {
            claimedTag = tagger.func_150295_c("claimedPlayers", 10);
            for (INBT inbt : claimedTag) {
                nbt = (CompoundNBT)inbt;
                this.claimed.add(new LootClaim(nbt.func_186857_a("Claimer"), nbt.func_74763_f("timeClaimed")));
            }
        }
        if (this.type == EnumPokegiftType.GIFT) {
            this.pokemon = tagger.func_74764_b("pixelmon") ? PokemonFactory.create(tagger.func_74775_l("pixelmon")) : null;
        } else if (tagger.func_74764_b("specials")) {
            claimedTag = tagger.func_150295_c("specials", 10);
            for (INBT inbt : claimedTag) {
                nbt = (CompoundNBT)inbt;
                this.specialPixelmon.add(PokemonSpecificationProxy.fromNbt(nbt));
            }
        }
        super.func_230337_a_(state, tagger);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = super.func_189517_E_();
        this.func_189515_b(compound);
        compound.func_82580_o("claimedPlayers");
        compound.func_82580_o("specials");
        compound.func_82580_o("pixelmon");
        return compound;
    }

    public boolean canClaim(UUID playerID) {
        if (!this.dropOneTime) {
            return true;
        }
        LootClaim claim = this.getLootClaim(playerID);
        return claim == null;
    }

    public LootClaim getLootClaim(UUID playerID) {
        for (LootClaim claim : this.claimed) {
            if (!claim.getPlayerID().toString().equals(playerID.toString())) continue;
            return claim;
        }
        return null;
    }

    public void addClaimer(UUID playerID) {
        if (this.dropOneTime) {
            this.claimed.add(new LootClaim(playerID, System.currentTimeMillis()));
        }
    }

    public void removeClaimer(UUID playerID) {
        this.claimed.remove(this.getLootClaim(playerID));
    }

    public boolean shouldBreakBlock() {
        return this.chestOneTime;
    }

    public void setChestOneTime(boolean val) {
        this.chestOneTime = val;
    }

    public boolean getChestMode() {
        return this.chestOneTime;
    }

    public void setDropOneTime(boolean val) {
        this.dropOneTime = val;
    }

    public boolean getDropMode() {
        return this.dropOneTime;
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public Pokemon getPokemon() {
        return this.pokemon;
    }

    public void setPokemon(Pokemon pokemon) {
        this.pokemon = pokemon;
    }

    public List<PokemonSpecification> getSpecialPixelmon() {
        return this.specialPixelmon;
    }

    public void setAllSpecialPixelmon(List<PokemonSpecification> pixelmon) {
        this.specialPixelmon.clear();
        this.specialPixelmon.addAll(pixelmon);
    }

    public void setSpecialPixelmon(PokemonSpecification pixelmon) {
        this.specialPixelmon.add(pixelmon);
    }

    public EnumPokechestVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(EnumPokechestVisibility visible) {
        this.visibility = visible;
        this.field_145850_b.func_225319_b(this.field_174879_c, this.func_195044_w(), this.func_195044_w());
    }
}

