/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.api.recipe.InfuserRecipe;
import com.pixelmonmod.pixelmon.api.recipe.QuantifiedIngredient;
import com.pixelmonmod.pixelmon.client.gui.machines.infuser.InfuserContainer;
import com.pixelmonmod.pixelmon.init.registry.RecipeTypeRegistration;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class InfuserTileEntity
extends TileEntity
implements ISidedInventory,
ITickableTileEntity,
INamedContainerProvider {
    private static final int INFUSION_TIME = 200;
    public int infuserRunTime;
    public int currentItemRunTime;
    public int infuserProgressTime;
    public int renderPass = 0;
    public boolean isRunning = false;
    public Item itemOnInfuser = null;
    public Item secondItemOnInfuser = null;
    public int state = 0;
    public int frame = 0;
    private NonNullList<ItemStack> infuserItemStacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private int stateTimer = 0;

    public InfuserTileEntity() {
        super((TileEntityType)TileEntityRegistration.INFUSER.get());
    }

    public int func_70302_i_() {
        return this.infuserItemStacks.size();
    }

    public NonNullList<ItemStack> getInfuserItemStacks() {
        return this.infuserItemStacks;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.infuserItemStacks) {
            if (itemstack == null || itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return (ItemStack)this.infuserItemStacks.get(slotIndex);
    }

    public ItemStack func_70298_a(int slotIndex, int decreaseBy) {
        if (!((ItemStack)this.infuserItemStacks.get(slotIndex)).func_190926_b()) {
            ItemStack itemStack;
            if (((ItemStack)this.infuserItemStacks.get(slotIndex)).func_190916_E() <= decreaseBy) {
                itemStack = (ItemStack)this.infuserItemStacks.get(slotIndex);
                this.infuserItemStacks.set(slotIndex, (Object)ItemStack.field_190927_a);
            } else {
                itemStack = ((ItemStack)this.infuserItemStacks.get(slotIndex)).func_77946_l();
                itemStack.func_190918_g(decreaseBy);
                this.infuserItemStacks.set(slotIndex, (Object)itemStack);
                if (((ItemStack)this.infuserItemStacks.get(slotIndex)).func_190916_E() == 0) {
                    this.infuserItemStacks.set(slotIndex, (Object)ItemStack.field_190927_a);
                }
            }
            itemStack = itemStack.func_77946_l();
            itemStack.func_190920_e(decreaseBy);
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (!((ItemStack)this.infuserItemStacks.get(slotIndex)).func_190926_b()) {
            ItemStack itemStack = (ItemStack)this.infuserItemStacks.get(slotIndex);
            this.infuserItemStacks.set(slotIndex, (Object)ItemStack.field_190927_a);
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        this.infuserItemStacks.set(slotIndex, (Object)itemStack);
        if (!itemStack.func_190926_b() && itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        ItemStack item = this.func_70301_a(3);
        if (item != null && !item.func_190926_b()) {
            return false;
        }
        switch (slotIndex) {
            case 0: {
                return ForgeHooks.getBurnTime((ItemStack)itemStack, (IRecipeType)IRecipeType.field_222150_b) > 0;
            }
            case 1: {
                return itemStack.func_77973_b().getTags().stream().anyMatch(r -> r.toString().equalsIgnoreCase("pixelmon:berries")) || itemStack.func_77973_b() == Items.field_196130_bo;
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int slotIndex, ItemStack itemStack, Direction direction) {
        switch (slotIndex) {
            case 0: {
                return itemStack.func_77973_b() == Items.field_151133_ar;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        nbt.func_74757_a("isRunning", this.isRunning());
        if (!((ItemStack)this.infuserItemStacks.get(1)).func_190926_b()) {
            nbt.func_218657_a("itemInInfuser", (INBT)((ItemStack)this.infuserItemStacks.get(1)).func_77955_b(new CompoundNBT()));
        }
        if (!((ItemStack)this.infuserItemStacks.get(2)).func_190926_b()) {
            nbt.func_218657_a("secondaryItemInInfuser", (INBT)((ItemStack)this.infuserItemStacks.get(2)).func_77955_b(new CompoundNBT()));
        }
        return nbt;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        this.isRunning = nbt.func_74767_n("isRunning");
        this.itemOnInfuser = nbt.func_74764_b("itemInInfuser") ? ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("itemInInfuser")).func_77973_b() : null;
        this.secondItemOnInfuser = nbt.func_74764_b("secondaryItemInInfuser") ? ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("secondaryItemInInfuser")).func_77973_b() : null;
        if (this.isRunning) {
            this.frame = 0;
        } else {
            this.itemOnInfuser = null;
            this.secondItemOnInfuser = null;
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbtTagCompound) {
        super.func_230337_a_(state, nbtTagCompound);
        ListNBT nbttaglist = nbtTagCompound.func_150295_c("Items", 10);
        this.infuserItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundNBT nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.infuserItemStacks.size()) continue;
            this.infuserItemStacks.set((int)b0, (Object)ItemStack.func_199557_a((CompoundNBT)nbttagcompound1));
        }
        this.infuserRunTime = nbtTagCompound.func_74765_d("RunTime");
        this.infuserProgressTime = nbtTagCompound.func_74765_d("InfusionTime");
        this.currentItemRunTime = ((ItemStack)this.infuserItemStacks.get(1)).getBurnTime();
    }

    public CompoundNBT func_189515_b(CompoundNBT nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74777_a("RunTime", (short)this.infuserRunTime);
        nbtTagCompound.func_74777_a("InfusionTime", (short)this.infuserProgressTime);
        ListNBT nbttaglist = new ListNBT();
        for (int i = 0; i < this.infuserItemStacks.size(); ++i) {
            if (((ItemStack)this.infuserItemStacks.get(i)).func_190926_b()) continue;
            CompoundNBT nbttagcompound1 = new CompoundNBT();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.infuserItemStacks.get(i)).func_77955_b(nbttagcompound1);
            nbttaglist.add((Object)nbttagcompound1);
        }
        nbtTagCompound.func_218657_a("Items", (INBT)nbttaglist);
        return nbtTagCompound;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getInfusionProgressScaled(int p_145953_1_) {
        return this.infuserProgressTime * p_145953_1_ / 200;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBurnTimeRemainingScaled(int p_145955_1_) {
        if (this.currentItemRunTime == 0) {
            this.currentItemRunTime = 200;
        }
        return this.infuserRunTime * p_145955_1_ / this.currentItemRunTime;
    }

    public boolean isRunning() {
        return this.infuserRunTime > 0;
    }

    public void func_73660_a() {
        boolean flag = this.infuserRunTime > 0;
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.infuserRunTime > 0) {
                --this.infuserRunTime;
                if (this.infuserRunTime == 0) {
                    ((ServerWorld)this.field_145850_b).func_72863_F().func_217217_a(this.field_174879_c);
                    this.isRunning = false;
                }
            }
            if (((ItemStack)this.infuserItemStacks.get(1)).func_190926_b() || ((ItemStack)this.infuserItemStacks.get(2)).func_190926_b()) {
                this.infuserProgressTime = 0;
            }
            if (this.infuserRunTime != 0 || !((ItemStack)this.infuserItemStacks.get(2)).func_190926_b() && !((ItemStack)this.infuserItemStacks.get(1)).func_190926_b() && !((ItemStack)this.infuserItemStacks.get(0)).func_190926_b()) {
                if (this.infuserRunTime == 0) {
                    this.currentItemRunTime = this.infuserRunTime = ForgeHooks.getBurnTime((ItemStack)((ItemStack)this.infuserItemStacks.get(0)), (IRecipeType)IRecipeType.field_222150_b);
                    ((ServerWorld)this.field_145850_b).func_72863_F().func_217217_a(this.field_174879_c);
                    if (this.infuserRunTime > 0) {
                        flag1 = true;
                        this.isRunning = true;
                        if (!((ItemStack)this.infuserItemStacks.get(0)).func_190926_b()) {
                            if (((ItemStack)this.infuserItemStacks.get(0)).func_190916_E() == 1) {
                                this.infuserItemStacks.set(0, (Object)((ItemStack)this.infuserItemStacks.get(0)).func_77973_b().getContainerItem((ItemStack)this.infuserItemStacks.get(0)));
                            } else {
                                ((ItemStack)this.infuserItemStacks.get(0)).func_190918_g(1);
                            }
                        }
                    }
                }
                if (this.isRunning) {
                    LazyOptional cap = this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN);
                    Object tileInventory = cap.isPresent() ? (IItemHandler)cap.orElseThrow(AssertionError::new) : new InvWrapper((IInventory)this);
                    boolean nonColorfulShakeFound = false;
                    for (InfuserRecipe recipe : ServerLifecycleHooks.getCurrentServer().func_199529_aN().func_241447_a_(RecipeTypeRegistration.INFUSER_RECIPE_TYPE)) {
                        if (recipe == null || Objects.requireNonNull(recipe.func_77571_b().func_77973_b().getRegistryName()).func_110623_a().equalsIgnoreCase("colorful_shake") || !recipe.func_77569_a((IInventory)this, this.field_145850_b)) continue;
                        ++this.infuserProgressTime;
                        if (this.infuserProgressTime >= 200) {
                            this.createInfuserItem(recipe, (IItemHandler)tileInventory);
                        }
                        flag1 = true;
                        nonColorfulShakeFound = true;
                        break;
                    }
                    if (!nonColorfulShakeFound) {
                        for (InfuserRecipe recipe : ServerLifecycleHooks.getCurrentServer().func_199529_aN().func_241447_a_(RecipeTypeRegistration.INFUSER_RECIPE_TYPE)) {
                            if (recipe == null || !Objects.requireNonNull(recipe.func_77571_b().func_77973_b().getRegistryName()).func_110623_a().equalsIgnoreCase("colorful_shake") || !recipe.func_77569_a((IInventory)this, this.field_145850_b)) continue;
                            ++this.infuserProgressTime;
                            if (this.infuserProgressTime >= 200) {
                                this.createInfuserItem(recipe, (IItemHandler)tileInventory);
                            }
                            flag1 = true;
                            break;
                        }
                    }
                }
            }
            if (flag != this.infuserRunTime > 0) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
        if (this.isRunning) {
            this.frame += 2;
            if (this.frame == 200) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187599_cE, SoundCategory.BLOCKS, 0.7f, 1.0f);
            }
            if (this.frame > 399) {
                this.frame = 0;
            }
            ++this.stateTimer;
            if (this.stateTimer > 66 && this.state == 0) {
                this.state = 1;
            }
            if (this.stateTimer > 133 && this.state == 1) {
                this.state = 2;
            }
            if (this.stateTimer >= 199) {
                this.state = 0;
            }
            if (this.stateTimer == 200) {
                this.stateTimer = 0;
            }
        } else {
            this.frame = 0;
            this.stateTimer = 0;
            this.state = 0;
        }
    }

    private boolean createInfuserItem(InfuserRecipe recipe, IItemHandler tileInventory) {
        ItemStack currentOut = (ItemStack)this.infuserItemStacks.get(3);
        if (currentOut.func_190926_b()) {
            this.infuserProgressTime = 0;
            ((ItemStack)this.infuserItemStacks.get(1)).func_190918_g(((QuantifiedIngredient)recipe.getQualifiedIngredients().get((int)0)).quantity);
            ((ItemStack)this.infuserItemStacks.get(2)).func_190918_g(((QuantifiedIngredient)recipe.getQualifiedIngredients().get((int)1)).quantity);
            this.infuserItemStacks.set(3, (Object)recipe.func_77572_b((IInventory)this).func_77946_l());
            return true;
        }
        if (tileInventory != null && recipe != null && Math.min(tileInventory.getSlotLimit(3), ((ItemStack)this.infuserItemStacks.get(3)).func_77976_d()) >= currentOut.func_190916_E() + recipe.func_77572_b((IInventory)this).func_190916_E()) {
            this.infuserProgressTime = 0;
            ((ItemStack)this.infuserItemStacks.get(1)).func_190918_g(((QuantifiedIngredient)recipe.getQualifiedIngredients().get((int)0)).quantity);
            ((ItemStack)this.infuserItemStacks.get(2)).func_190918_g(((QuantifiedIngredient)recipe.getQualifiedIngredients().get((int)1)).quantity);
            currentOut.func_190917_f(recipe.func_77572_b((IInventory)this).func_190916_E());
            this.infuserItemStacks.set(3, (Object)currentOut);
            return true;
        }
        return false;
    }

    public void func_174889_b(PlayerEntity playerIn) {
    }

    public void func_174886_c(PlayerEntity playerIn) {
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return StringTextComponent.field_240750_d_;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
        return new InfuserContainer(id, inventory, this);
    }
}

