/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.enums.items.EnumFossils;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.FossilItem;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;

public class FossilMachineTileEntity
extends TileEntity
implements ITickableTileEntity {
    public static final int MAX_POKEMON_PROGRESS = 3200;
    public static final int MAX_FOSSIL_PROGRESS = 1600;
    public int renderPass = 0;
    public StatueEntity statue = null;
    public float fossilJitter;
    public int screenFlickerTick;
    public boolean staticFlicker = false;
    public int dotTicks = 0;
    public String dots = "";
    public boolean pokemonOccupied = false;
    public EnumFossils currentFossil = EnumFossils.NULL;
    public float fossilProgress = 0.0f;
    public String currentPokemon = "";
    public float pokemonProgress = 0.0f;
    public int completionRate = (int)((this.fossilProgress + this.pokemonProgress) * 2.0f / 96.0f);
    public int completionSync = 0;
    public boolean isShiny = false;
    public PokeBall pokeball = null;

    public FossilMachineTileEntity() {
        super((TileEntityType)TileEntityRegistration.FOSSIL_MACHINE.get());
    }

    public void func_73660_a() {
        if (this.completionRate != 100 && (this.fossilProgress > 0.0f || this.pokemonProgress > 0.0f)) {
            this.completionRate = (int)((this.fossilProgress + this.pokemonProgress) * 2.0f / 96.0f);
            if (!this.func_145831_w().field_72995_K && this.completionRate % 10 == 0 && this.completionSync != this.completionRate) {
                this.field_145850_b.func_225319_b(this.field_174879_c, this.func_195044_w(), this.func_195044_w());
                this.completionSync = this.completionRate;
            }
        }
        if (this.currentFossil.getPokemon() != null) {
            if (this.fossilProgress < 1600.0f) {
                this.fossilProgress += 1.0f;
            } else if (!this.func_145831_w().field_72995_K) {
                this.swapFossilForPokemon();
                this.field_145850_b.func_225319_b(this.field_174879_c, this.func_195044_w(), this.func_195044_w());
            }
        }
        if (this.pokemonOccupied && this.pokemonProgress < 3200.0f) {
            this.pokemonProgress += 1.0f;
        }
        if (++this.dotTicks > 10) {
            this.dotTicks = 0;
            this.dots = this.dots.length() < 6 ? this.dots + "." : "";
        }
        float f = this.fossilJitter = this.fossilJitter == 0.0f ? 0.01f : 0.0f;
        this.screenFlickerTick = this.staticFlicker ? --this.screenFlickerTick : ++this.screenFlickerTick;
        if (this.screenFlickerTick >= 8) {
            this.staticFlicker = true;
        } else if (this.screenFlickerTick <= 0) {
            this.staticFlicker = false;
        }
        if (this.completionRate < 98) {
            int num = this.completionRate <= 50 ? this.completionRate / 4 : (100 - this.completionRate) / 4;
            double var9 = (float)this.func_174877_v().func_177956_o() + 0.4f;
            for (int i = 0; i < num; ++i) {
                WorldHelper.spawnRedstoneParticle(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.1 + (double)this.func_145831_w().field_73012_v.nextFloat() * 0.7, var9 + (double)this.func_145831_w().field_73012_v.nextFloat() + (double)(this.func_145831_w().field_73012_v.nextFloat() * 0.4f), (double)this.func_174877_v().func_177952_p() + 0.1 + (double)this.func_145831_w().field_73012_v.nextFloat() * 0.7, 0.0, 1.2, 1.0);
            }
        }
    }

    public void swapFossilForPokemon() {
        this.currentPokemon = this.currentFossil.getPokemon().getName();
        this.pokemonOccupied = true;
        RegistryKey world = this.func_145831_w() == null ? null : this.func_145831_w().func_234923_W_();
        this.isShiny = PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)world) > 0.0f && RandomHelper.rand.nextFloat() < 1.0f / PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)world);
        this.currentFossil = EnumFossils.NULL;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.pokeball != null) {
            nbt.func_74778_a("PokeballID", this.pokeball.getName());
        }
        nbt.func_74768_a("CurrentFossil", this.currentFossil.getIndex());
        nbt.func_74768_a("FossilType", this.currentFossil.getIndex());
        nbt.func_74776_a("PokemonProgress", this.pokemonProgress);
        nbt.func_74776_a("FossilProgress", this.fossilProgress);
        nbt.func_74778_a("CurrentPokemon", this.currentPokemon);
        nbt.func_74757_a("IsShiny", this.isShiny);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.pokeball = nbt.func_150297_b("PokeballID", 8) ? PokeBallRegistry.getPokeBall(nbt.func_74779_i("PokeballID")).orElse((PokeBall)null) : null;
        if (nbt.func_74764_b("CurrentFossil")) {
            int curFos = nbt.func_74762_e("CurrentFossil");
            this.currentFossil = Item.func_150899_d((int)curFos) instanceof FossilItem ? ((FossilItem)Item.func_150899_d((int)curFos)).fossil : EnumFossils.NULL;
        }
        if (nbt.func_74764_b("FossilType")) {
            this.currentFossil = EnumFossils.fromIndex(nbt.func_74762_e("FossilType"));
        }
        this.fossilProgress = nbt.func_74760_g("FossilProgress");
        this.pokemonProgress = nbt.func_74760_g("PokemonProgress");
        this.currentPokemon = nbt.func_74779_i("CurrentPokemon");
        this.pokemonOccupied = !this.currentPokemon.equals("");
        this.completionRate = (int)((this.fossilProgress + this.pokemonProgress) * 2.0f / 96.0f);
        if (nbt.func_74764_b("IsShiny")) {
            this.isShiny = nbt.func_74767_n("IsShiny");
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        nbt.func_74768_a("CurrentFossil", this.currentFossil.getIndex());
        return nbt;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }
}

