/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.FormRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.GenderRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.PaletteRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.ShinyRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class PokemonRarity {
    public PokemonSpecification pokemon;
    public int rarity;

    public PokemonRarity(PokemonSpecification pokemon, int rarity) {
        this.pokemon = pokemon;
        this.rarity = rarity;
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_180714_a(this.pokemon.toString());
        buffer.writeInt(this.rarity);
    }

    public void writeToList(ListNBT list) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("pokemon", (INBT)this.pokemon.write(new CompoundNBT()));
        nbt.func_74768_a("rarity", this.rarity);
        list.add((Object)nbt);
    }

    public ResourceLocation getSprite() {
        Species species = this.pokemon.getValue(SpeciesRequirement.class).orElse(PixelmonSpecies.BULBASAUR).getValueUnsafe();
        Stats form = this.pokemon.getValue(FormRequirement.class).map(species::getForm).orElse(species.getDefaultForm());
        Gender gender = this.pokemon.getValue(GenderRequirement.class).orElse(form.getDefaultGender());
        String palette = this.pokemon.getValue(PaletteRequirement.class).orElseGet(() -> this.pokemon.getValue(ShinyRequirement.class).filter(b -> b).map(b -> "shiny").orElse("none"));
        PaletteProperties paletteProperties = form.getGenderProperties(gender).getPalette(palette);
        if (paletteProperties == null) {
            return form.getGenderProperties(gender).getDefaultPalette().getSprite();
        }
        return paletteProperties.getSprite();
    }

    public static List<PokemonRarity> fromNbt(CompoundNBT nbt) {
        ArrayList specs = Lists.newArrayList();
        if (!nbt.func_74764_b("specs")) {
            return specs;
        }
        ListNBT specs1 = nbt.func_150295_c("specs", 10);
        for (INBT inbt : specs1) {
            CompoundNBT spec = (CompoundNBT)inbt;
            PokemonSpecification pokemonSpec = PokemonSpecificationProxy.fromNbt(spec.func_74775_l("pokemon"));
            int rarity = spec.func_74762_e("rarity");
            specs.add(new PokemonRarity(pokemonSpec, rarity));
        }
        return specs;
    }

    public static void addToNbt(CompoundNBT nbt, List<PokemonRarity> rarities) {
        ListNBT list = new ListNBT();
        for (PokemonRarity rarity : rarities) {
            rarity.writeToList(list);
        }
        nbt.func_218657_a("specs", (INBT)list);
    }

    public static PokemonRarity readFromBuffer(PacketBuffer buffer) {
        return new PokemonRarity(PokemonSpecificationProxy.create(buffer.func_218666_n()), buffer.readInt());
    }
}

