/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.GenericModelBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.ZygardeCellTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ZygardeCellBlock
extends GenericModelBlock {
    public static final DirectionProperty ORIENTATION_PROPERTY = DirectionProperty.func_196962_a((String)"orientation", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN});
    public static final DirectionProperty ROTATION_PROPERTY = DirectionProperty.func_196962_a((String)"rotation", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN});
    private static final AxisAlignedBB[] AABB_DOWN_ROTATE = new AxisAlignedBB[]{new AxisAlignedBB(0.26, 0.0, 0.1, 0.74, 0.05, 0.85), new AxisAlignedBB(0.15, 0.0, 0.26, 0.8, 0.05, 0.74), new AxisAlignedBB(0.26, 0.0, 0.15, 0.74, 0.05, 0.8), new AxisAlignedBB(0.1, 0.0, 0.26, 0.85, 0.05, 0.74)};
    private static final AxisAlignedBB[] AABB_UP_ROTATE = new AxisAlignedBB[]{new AxisAlignedBB(0.26, 0.95, 0.1, 0.74, 1.0, 0.85), new AxisAlignedBB(0.15, 0.95, 0.26, 0.8, 1.0, 0.74), new AxisAlignedBB(0.26, 0.95, 0.15, 0.74, 1.0, 0.8), new AxisAlignedBB(0.1, 0.95, 0.26, 0.85, 1.0, 0.74)};
    private static final AxisAlignedBB[] AABB_SIDES = new AxisAlignedBB[]{new AxisAlignedBB(0.26, 0.1, 1.0, 0.74, 0.9, 0.95), new AxisAlignedBB(0.0, 0.1, 0.26, 0.05, 0.9, 0.74), new AxisAlignedBB(0.26, 0.1, 0.0, 0.74, 0.9, 0.05), new AxisAlignedBB(1.0, 0.1, 0.26, 0.95, 0.9, 0.74)};

    public ZygardeCellBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.0f));
        ((BlockState)this.func_176223_P().func_206870_a((Property)ORIENTATION_PROPERTY, (Comparable)Direction.NORTH)).func_206870_a((Property)ROTATION_PROPERTY, (Comparable)Direction.DOWN);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ORIENTATION_PROPERTY, ROTATION_PROPERTY});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction orientation = context.func_196000_l().func_176734_d();
        Direction rotation = orientation.func_176740_k() == Direction.Axis.Y ? context.func_195992_f() : (context.func_195999_j().field_70125_A > 0.0f ? Direction.UP : Direction.DOWN);
        BlockState state = super.func_196258_a(context);
        return (BlockState)((BlockState)state.func_206870_a((Property)ORIENTATION_PROPERTY, (Comparable)orientation)).func_206870_a((Property)ROTATION_PROPERTY, (Comparable)rotation);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            BlockItem.func_179224_a((World)worldIn, (PlayerEntity)((PlayerEntity)placer), (BlockPos)pos, (ItemStack)stack);
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ZygardeCellTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction orientation = (Direction)state.func_177229_b((Property)ORIENTATION_PROPERTY);
        Direction value = (Direction)state.func_177229_b((Property)ROTATION_PROPERTY);
        if (orientation.func_176740_k() == Direction.Axis.Y) {
            if (value.func_176740_k() == Direction.Axis.Y) {
                return VoxelShapes.func_197881_a((AxisAlignedBB)AABB_DOWN_ROTATE[0]);
            }
            if (orientation == Direction.UP) {
                return VoxelShapes.func_197881_a((AxisAlignedBB)AABB_UP_ROTATE[value.func_176736_b()]);
            }
            return VoxelShapes.func_197881_a((AxisAlignedBB)AABB_DOWN_ROTATE[value.func_176736_b()]);
        }
        if (value.func_176740_k() == Direction.Axis.X) {
            return VoxelShapes.func_197881_a((AxisAlignedBB)AABB_SIDES[0]);
        }
        return VoxelShapes.func_197881_a((AxisAlignedBB)AABB_SIDES[orientation.func_176736_b()]);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_225541_a_(BlockState state, Fluid fluid) {
        return true;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canBlockStay(worldIn, state, pos, fromPos)) {
            worldIn.func_217377_a(pos, false);
        }
    }

    public boolean canBlockStay(World worldIn, BlockState state, BlockPos pos, BlockPos newBlockPos) {
        ZygardeCellTileEntity cell = BlockHelper.getTileEntity(ZygardeCellTileEntity.class, (IBlockReader)worldIn, pos);
        if (cell == null) {
            return false;
        }
        TileEntity neighbor = BlockHelper.getTileEntity(TileEntity.class, (IBlockReader)worldIn, newBlockPos);
        if (cell.isPermanent() || neighbor instanceof ZygardeCellTileEntity) {
            return true;
        }
        Material mat = worldIn.func_180495_p(pos = pos.func_177972_a((Direction)state.func_177229_b((Property)ORIENTATION_PROPERTY))).func_185904_a();
        return mat == Material.field_151584_j || mat == Material.field_151577_b || mat == Material.field_151575_d;
    }
}

