/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.tasks;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.tasks.BattleTaskPacket;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.battles.tasks.SwitchTask;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.TimerTask;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SwitchOutTask
extends BattleTaskPacket {
    private UUID pokemonUUID;
    private PixelmonClientData newPokemon;
    private SwitchTask task;

    public SwitchOutTask() {
    }

    public SwitchOutTask(UUID pokemonUUID, PixelmonClientData newPokemon) {
        this.pokemonUUID = pokemonUUID;
        this.newPokemon = newPokemon;
    }

    public SwitchOutTask(UUID pix1UUID, PixelmonWrapper newPokemon) {
        this.pokemonUUID = pix1UUID;
        this.newPokemon = new PixelmonClientData(newPokemon);
    }

    public SwitchOutTask(UUID pix1UUID) {
        this.pokemonUUID = pix1UUID;
        this.newPokemon = null;
    }

    @Override
    public boolean process(ClientBattleManager bm) {
        if (this.task == null) {
            this.task = new SwitchTask(this.pokemonUUID, this.newPokemon);
            ClientBattleManager.TIMER.scheduleAtFixedRate((TimerTask)this.task, 0L, 5L);
        }
        return !this.task.isDone();
    }

    @Override
    @Nullable
    public UUID getPokemonID() {
        return this.pokemonUUID;
    }

    @Override
    public boolean shouldRunParallel() {
        return true;
    }

    @Override
    public void decode(PacketBuffer buf) {
        if (buf.readBoolean()) {
            this.pokemonUUID = buf.func_179253_g();
        }
        if (buf.readBoolean()) {
            this.newPokemon = new PixelmonClientData();
            this.newPokemon.decodeFrom(buf);
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeBoolean(this.pokemonUUID != null);
        if (this.pokemonUUID != null) {
            buf.func_179252_a(this.pokemonUUID);
        }
        buf.writeBoolean(this.newPokemon != null);
        if (this.newPokemon != null) {
            this.newPokemon.encodeInto(buf);
        }
    }
}

