/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.EntryHazard;
import com.pixelmonmod.pixelmon.battles.status.Poison;
import com.pixelmonmod.pixelmon.battles.status.PoisonBadly;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class ToxicSpikes
extends EntryHazard {
    public ToxicSpikes() {
        super(StatusType.ToxicSpikes, 2);
    }

    @Override
    public boolean isUnharmed(PixelmonWrapper pw) {
        return super.isUnharmed(pw) || pw.hasType(Element.STEEL) || this.isAirborne(pw);
    }

    @Override
    public void applyEffectOnSwitch(PixelmonWrapper pw) {
        if (!this.isUnharmed(pw)) {
            this.doEffect(pw);
        }
    }

    @Override
    protected void doEffect(PixelmonWrapper pw) {
        Poison poison;
        if (pw.hasType(Element.POISON)) {
            pw.bc.sendToAll("pixelmon.status.toxicspikesabsorbed", pw.getNickname());
            pw.removeTeamStatus(this);
            return;
        }
        Poison poison2 = poison = this.numLayers == 1 ? new Poison() : new PoisonBadly();
        if (pw.addStatus(poison, pw)) {
            pw.bc.sendToAll(this.getAffectedMessage(), pw.getNickname());
        }
    }

    @Override
    public EntryHazard getNewInstance() {
        return new ToxicSpikes();
    }

    @Override
    protected String getFirstLayerMessage() {
        return "pixelmon.effect.toxicspikes";
    }

    @Override
    protected String getMultiLayerMessage() {
        return "pixelmon.effect.moretoxicspikes";
    }

    @Override
    protected String getAffectedMessage() {
        return this.numLayers == 1 ? "pixelmon.status.toxicspikespoisoned" : "pixelmon.status.toxicspikesbadlypoisoned";
    }

    @Override
    public int getAIWeight() {
        return 15;
    }
}

