/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.DrySkin;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Hydration;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.IgnoreWeather;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.RainDish;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SwiftSwim;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;

public class Rainy
extends Weather {
    public Rainy() {
        this(5);
    }

    public Rainy(boolean extreme) {
        this(-1);
        this.extreme = extreme;
        this.langContinue = "pixelmon.status.extremelyheavyrain";
    }

    public Rainy(int turnsToGo) {
        super(StatusType.Rainy, turnsToGo, EnumHeldItems.dampRock, "pixelmon.effect.raining", "pixelmon.status.heavyrain", "pixelmon.status.rainstopped", false, false);
    }

    public Rainy(int turnsToGo, boolean isOverworldWeather) {
        super(StatusType.Rainy, turnsToGo, EnumHeldItems.dampRock, "pixelmon.effect.raining", "pixelmon.status.heavyrain", "pixelmon.status.rainstopped", false, isOverworldWeather);
    }

    @Override
    protected Weather getNewInstance(int turns) {
        return new Rainy(turns);
    }

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (!a.ignoresWeather(user)) {
            if (a.getType() == Element.WATER) {
                power = (int)((double)power * 1.5);
            } else if (a.getType() == Element.FIRE) {
                power = (int)((double)power * 0.5);
            }
        }
        return new int[]{power, accuracy};
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        Attack attack = user.attack;
        if (!attack.ignoresWeather(user) && this.extreme && Attack.dealsDamage(attack) && attack.getType() == Element.FIRE) {
            for (PixelmonWrapper pw : pokemon.bc.getActivePokemon()) {
                if (!(pw.getBattleAbility() instanceof IgnoreWeather)) continue;
                return false;
            }
            pokemon.bc.sendToAll("pixelmon.status.heavyrainfireattacks", new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        List<Attack> moveset;
        int benefits = 0;
        Ability ability = target.getBattleAbility();
        if (ability instanceof DrySkin || ability instanceof Hydration || ability instanceof RainDish || ability instanceof SwiftSwim) {
            ++benefits;
        }
        if (Attack.hasOffensiveAttackType(moveset = user.getBattleAI().getMoveset(target), Element.WATER) || Attack.hasAttack(moveset, AttackRegistry.WEATHER_BALL)) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.HURRICANE)) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.THUNDER)) {
            ++benefits;
        }
        if (Attack.hasOffensiveAttackType(moveset, Element.FIRE)) {
            --benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.SOLAR_BEAM)) {
            --benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.MOONLIGHT, AttackRegistry.MORNING_SUN, AttackRegistry.SYNTHESIS)) {
            --benefits;
        }
        return benefits;
    }

    @Override
    public StatusBase copy() {
        return new Rainy(this.turnsToGo);
    }
}

