/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.DrySkin;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.IceBody;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Moody;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.PoisonHeal;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.RainDish;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SlowStart;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SolarPower;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SpeedBoost;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Truant;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Hail;
import com.pixelmonmod.pixelmon.battles.status.ProtectVariation;
import com.pixelmonmod.pixelmon.battles.status.Rainy;
import com.pixelmonmod.pixelmon.battles.status.Sandstorm;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Sunny;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;

public class Protect
extends ProtectVariation {
    public Protect() {
        this(StatusType.Protect);
    }

    public Protect(StatusType type) {
        super(type);
    }

    @Override
    protected boolean addStatus(PixelmonWrapper user) {
        return user.addStatus(new Protect(), user);
    }

    @Override
    protected void displayMessage(PixelmonWrapper user) {
        user.bc.sendToAll("pixelmon.effect.redaying", user.getNickname());
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        return super.stopsIncomingAttack(pokemon, user) && !user.attack.isAttack(AttackRegistry.ACUPRESSURE, AttackRegistry.AROMATIC_MIST, AttackRegistry.BESTOW, AttackRegistry.BLOCK, AttackRegistry.CONFIDE, AttackRegistry.CONVERSION_2, AttackRegistry.CURSE, AttackRegistry.DECORATE, AttackRegistry.DOOM_DESIRE, AttackRegistry.FEINT, AttackRegistry.FLOWER_SHIELD, AttackRegistry.FUTURE_SIGHT, AttackRegistry.HOLD_HANDS, AttackRegistry.HYPERSPACE_FURY, AttackRegistry.HYPERSPACE_HOLE, AttackRegistry.MEAN_LOOK, AttackRegistry.NIGHTMARE, AttackRegistry.PERISH_SONG, AttackRegistry.PHANTOM_FORCE, AttackRegistry.PLAY_NICE, AttackRegistry.PSYCH_UP, AttackRegistry.ROAR, AttackRegistry.ROLE_PLAY, AttackRegistry.ROTOTILLER, AttackRegistry.SHADOW_FORCE, AttackRegistry.SKETCH, AttackRegistry.SPIDER_WEB, AttackRegistry.TEARFUL_LOOK, AttackRegistry.TRANSFORM, AttackRegistry.WHIRLWIND, AttackRegistry.SPIKES, AttackRegistry.STEALTH_ROCK, AttackRegistry.STICKY_WEB, AttackRegistry.TOXIC_SPIKES);
    }

    @Override
    public void stopsIncomingAttackMessage(PixelmonWrapper pokemon, PixelmonWrapper user) {
        user.bc.sendToAll("pixelmon.effect.redaying", pokemon.getNickname());
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        pw.removeStatus(this);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        List<MoveChoice> targetedChoices;
        if (MoveChoice.canBreakProtect(pw.getOpponentPokemon(), bestOpponentChoices)) {
            userChoice.raiseWeight(-1.0f);
            return;
        }
        int numResidualUser = this.countStallBenefit(pw);
        int numResidualOpponent = 0;
        for (PixelmonWrapper opponent : pw.getOpponentPokemon()) {
            if (opponent.hasStatus(StatusType.Vanish)) {
                userChoice.raiseWeight(-1.0f);
                return;
            }
            numResidualOpponent += this.countStallBenefit(opponent);
        }
        if (numResidualUser < numResidualOpponent) {
            userChoice.raiseWeight(50.0f);
        }
        if (MoveChoice.hasSuccessfulAttackChoice(targetedChoices = MoveChoice.getTargetedChoices(pw, bestOpponentChoices), AttackRegistry.EXPLOSION, AttackRegistry.FAKE_OUT, AttackRegistry.JUMP_KICK, AttackRegistry.HIGH_JUMP_KICK, AttackRegistry.SELF_DESTRUCT)) {
            userChoice.raiseWeight(50.0f);
        }
        if (pw.bc.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getNumPokemon() > 1 && targetedChoices.size() > 0) {
            userChoice.raiseWeight(50.0f);
        }
        userChoice.weight /= (float)(1 << pw.protectsInARow);
    }

    private int countStallBenefit(PixelmonWrapper pw) {
        Ability ability = pw.getBattleAbility();
        boolean hasMagicGuard = ability instanceof MagicGuard;
        EnumHeldItems heldItem = pw.getUsableHeldItem().getHeldItemType();
        Weather weather = pw.bc.globalStatusController.getWeather();
        boolean fullHealth = pw.hasFullHealth();
        int numResidual = 0;
        numResidual += pw.countStatuses(StatusType.FutureSight, StatusType.LightScreen, StatusType.LuckyChant, StatusType.MagnetRise, StatusType.MultiTurn, StatusType.Mist, StatusType.Nightmare, StatusType.Perish, StatusType.Reflect, StatusType.SafeGuard, StatusType.Tailwind, StatusType.UnderGround, StatusType.Yawn);
        numResidual -= pw.countStatuses(StatusType.AquaRing, StatusType.Disable, StatusType.Embargo, StatusType.Encore, StatusType.Freeze, StatusType.GrassPledge, StatusType.HealBlock, StatusType.Ingrain, StatusType.Sleep, StatusType.Taunt, StatusType.Telekinesis, StatusType.WaterPledge, StatusType.Wish);
        if (!hasMagicGuard) {
            numResidual += pw.countStatuses(StatusType.Burn, StatusType.Cursed, StatusType.FirePledge, StatusType.Leech, StatusType.PartialTrap);
            int numPoison = pw.countStatuses(StatusType.Poison, StatusType.PoisonBadly);
            if (ability instanceof PoisonHeal) {
                if (!fullHealth) {
                    numResidual -= numPoison;
                }
            } else {
                numResidual += numPoison;
            }
        }
        if (!fullHealth) {
            numResidual -= pw.countStatuses(StatusType.AquaRing, StatusType.Ingrain, StatusType.Wish);
        }
        if (!fullHealth && heldItem == EnumHeldItems.leftovers || heldItem == EnumHeldItems.blackSludge && pw.hasType(Element.POISON)) {
            --numResidual;
        } else if (!(hasMagicGuard || heldItem != EnumHeldItems.stickyBarb && heldItem != EnumHeldItems.blackSludge)) {
            ++numResidual;
        }
        if (weather instanceof Rainy) {
            if (!fullHealth && (ability instanceof DrySkin || ability instanceof RainDish)) {
                --numResidual;
            }
        } else if (weather instanceof Sunny) {
            if (ability instanceof DrySkin || ability instanceof SolarPower) {
                ++numResidual;
            }
        } else if (weather instanceof Sandstorm) {
            if (!weather.isImmune(pw)) {
                ++numResidual;
            }
        } else if (weather instanceof Hail) {
            if (!fullHealth && ability instanceof IceBody) {
                --numResidual;
            } else if (!weather.isImmune(pw)) {
                ++numResidual;
            }
        }
        if (ability instanceof Moody || ability instanceof SpeedBoost || ability instanceof SlowStart) {
            --numResidual;
        } else if (ability instanceof Truant && ((Truant)ability).canMove) {
            ++numResidual;
        }
        return numResidual;
    }
}

