/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.LiquidOoze;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.util.List;

public class Leech
extends StatusBase {
    transient PixelmonWrapper leechRecipient;
    transient int recipientPosition;

    public Leech() {
        super(StatusType.Leech);
    }

    public Leech(PixelmonWrapper leechRecipient) {
        super(StatusType.Leech);
        this.leechRecipient = leechRecipient;
        this.recipientPosition = leechRecipient.battlePosition;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasStatus(StatusType.Leech)) {
            user.bc.sendToAll("pixelmon.effect.alreadyseeded", target.getNickname());
            if (user.attack != null && user.attack.moveResult != null) {
                user.attack.moveResult.result = AttackResult.failed;
            }
            return;
        }
        if (!target.hasType(Element.GRASS)) {
            if (target.addStatus(new Leech(user), user)) {
                user.bc.sendToAll("pixelmon.effect.seedplanted", user.getNickname());
            }
        } else {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            if (user.attack != null && user.attack.moveResult != null) {
                user.attack.moveResult.result = AttackResult.failed;
            }
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (this.leechRecipient != null) {
            for (PixelmonWrapper recipient : this.leechRecipient.getTeamPokemon()) {
                if (recipient.battlePosition == this.recipientPosition) {
                    this.leechRecipient = recipient;
                    break;
                }
                this.leechRecipient = null;
            }
        }
        Ability victimAbility = pw.getBattleAbility();
        if (this.leechRecipient == null || this.leechRecipient.isFainted() || victimAbility instanceof MagicGuard) {
            return;
        }
        pw.bc.sendToAll("pixelmon.status.drainhealth", this.leechRecipient.getNickname(), pw.getNickname());
        int dmg = pw.getPercentMaxHealth(12.5f);
        pw.doBattleDamage(this.leechRecipient, dmg, DamageTypeEnum.STATUS);
        if (HeldItem.canUseItem(this.leechRecipient) && this.leechRecipient.getUsableHeldItem().getHeldItemType() == EnumHeldItems.bigRoot) {
            dmg = (int)((double)dmg * 1.3);
        }
        if (victimAbility instanceof LiquidOoze) {
            this.leechRecipient.bc.sendToAll("pixelmon.abilities.liquidooze", this.leechRecipient.getNickname());
            this.leechRecipient.doBattleDamage(pw, dmg, DamageTypeEnum.ABILITY);
        } else if (!this.leechRecipient.hasStatus(StatusType.HealBlock)) {
            this.leechRecipient.healEntityBy(dmg);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            Ability targetAbility = target.getBattleAbility();
            if (targetAbility instanceof LiquidOoze || targetAbility instanceof MagicGuard) continue;
            userChoice.raiseWeight(35.0f);
        }
    }
}

