/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;
import java.util.List;

public class TidyUp
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        boolean clearedHazards = false;
        boolean clearedSubstitute = false;
        ArrayList<PixelmonWrapper> pokemonOnField = new ArrayList<PixelmonWrapper>(user.getTeamPokemon());
        pokemonOnField.addAll(user.getOpponentPokemon());
        for (PixelmonWrapper pw : pokemonOnField) {
            if (pw.removeTeamStatus(StatusType.Spikes, StatusType.StealthRock, StatusType.ToxicSpikes, StatusType.StickyWeb)) {
                clearedHazards = true;
            }
            if (!pw.removeStatus(StatusType.Substitute)) continue;
            clearedSubstitute = true;
        }
        if (clearedHazards) {
            user.bc.sendToAll("pixelmon.effect.clearspikes", user.getNickname());
        }
        if (clearedSubstitute) {
            user.bc.sendToAll("pixelmon.effect.clearsubstitute", user.getNickname());
        }
        return AttackResult.proceed;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        int total = 0;
        StatusType[] entryHazards = new StatusType[]{StatusType.Spikes, StatusType.StealthRock, StatusType.ToxicSpikes, StatusType.StickyWeb};
        total += pw.countStatuses(entryHazards);
        total -= pw.getOpponentPokemon().get(0).countStatuses(entryHazards);
        for (PixelmonWrapper allyTeam : pw.getTeamPokemon()) {
            total -= allyTeam.countStatuses(StatusType.Substitute);
        }
        for (PixelmonWrapper opponents : pw.getOpponentPokemon()) {
            total += opponents.countStatuses(StatusType.Substitute);
        }
        userChoice.raiseWeight(30 * total);
    }
}

