/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.List;
import java.util.Set;

public class Copycat
extends SpecialAttackBase {
    private static Set<ImmutableAttack> UNCOPYABLE_MOVES = null;
    private static Set<ImmutableAttack> COPYABLE_TEMP_MOVES = null;

    private static Set<ImmutableAttack> getUncopyableMoves() {
        if (UNCOPYABLE_MOVES == null) {
            UNCOPYABLE_MOVES = Sets.newHashSet((Object[])new ImmutableAttack[]{AttackRegistry.BANEFUL_BUNKER.get(), AttackRegistry.BEAK_BLAST.get(), AttackRegistry.BEHEMOTH_BASH.get(), AttackRegistry.BEHEMOTH_BLADE.get(), AttackRegistry.BESTOW.get(), AttackRegistry.CELEBRATE.get(), AttackRegistry.CHATTER.get(), AttackRegistry.CIRCLE_THROW.get(), AttackRegistry.COUNTER.get(), AttackRegistry.COVET.get(), AttackRegistry.DESTINY_BOND.get(), AttackRegistry.DETECT.get(), AttackRegistry.DRAGON_TAIL.get(), AttackRegistry.DYNAMAX_CANNON.get(), AttackRegistry.ENDURE.get(), AttackRegistry.FEINT.get(), AttackRegistry.FOCUS_PUNCH.get(), AttackRegistry.FOLLOW_ME.get(), AttackRegistry.HELPING_HAND.get(), AttackRegistry.HOLD_HANDS.get(), AttackRegistry.KINGS_SHIELD.get(), AttackRegistry.MAT_BLOCK.get(), AttackRegistry.MIRROR_COAT.get(), AttackRegistry.PROTECT.get(), AttackRegistry.RAGE_POWDER.get(), AttackRegistry.ROAR.get(), AttackRegistry.SHELL_TRAP.get(), AttackRegistry.SKETCH.get(), AttackRegistry.STRUGGLE.get(), AttackRegistry.SPIKY_SHIELD.get(), AttackRegistry.SPOTLIGHT.get(), AttackRegistry.SWITCHEROO.get(), AttackRegistry.THIEF.get(), AttackRegistry.TRANSFORM.get(), AttackRegistry.TRICK.get(), AttackRegistry.WHIRLWIND.get()});
        }
        return UNCOPYABLE_MOVES;
    }

    private static Set<ImmutableAttack> getCopyableTempMoves() {
        if (COPYABLE_TEMP_MOVES == null) {
            COPYABLE_TEMP_MOVES = Sets.newHashSet((Object[])new ImmutableAttack[]{AttackRegistry.ASSIST.get(), AttackRegistry.COPYCAT.get(), AttackRegistry.METRONOME.get(), AttackRegistry.ME_FIRST.get(), AttackRegistry.MIMIC.get(), AttackRegistry.MIRROR_MOVE.get(), AttackRegistry.SLEEP_TALK.get(), AttackRegistry.SNATCH.get()});
        }
        return COPYABLE_TEMP_MOVES;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        Attack attack;
        if (user.bc.simulateMode) {
            return AttackResult.ignore;
        }
        if (user.bc.lastAttack == null || user.bc.lastAttack.isZ || Copycat.getUncopyableMoves().contains(user.bc.lastAttack.getMove())) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        if (Copycat.getCopyableTempMoves().contains(user.bc.lastAttack.getMove())) {
            if (user.bc.lastTempAttack != null) {
                user.useTempAttack(user.bc.lastTempAttack);
                return AttackResult.ignore;
            }
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        Attack attack2 = attack = user.bc.lastAttack.isMax ? user.bc.lastAttack.originalMove : user.bc.lastAttack;
        if (attack.isAttack(AttackRegistry.COPYCAT)) {
            return AttackResult.ignore;
        }
        user.useTempAttack(attack);
        return AttackResult.ignore;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        List<MoveChoice> possibleChoices;
        if (MoveChoice.canOutspeed(bestOpponentChoices, pw, userChoice.createList())) {
            possibleChoices = MoveChoice.createChoicesFromChoices(pw, bestOpponentChoices, false);
        } else if (pw.bc.lastAttack != null) {
            possibleChoices = pw.bc.lastAttack.createMoveChoices(pw, false);
        } else {
            return;
        }
        pw.getBattleAI().weightRandomMove(pw, userChoice, possibleChoices);
    }
}

