/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.StandardParticleAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackSystem;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EffectType;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttackTube
extends AttackSystem<TubeData> {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Minecraft mc, World w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        this.getEndPos()[1] = (float)(w.func_73045_a(this.getEndID()) == null ? (double)this.getEndPos()[1] : w.func_73045_a(this.getEndID()).func_226278_cu_());
        for (int segment = 1; segment < ((TubeData)this.getData()).segments; ++segment) {
            for (int i = 0; i < ((TubeData)this.getData()).getPower(); ++i) {
                mc.field_71452_i.func_78873_a((Particle)new ParticleArcanery(this.getEndPos()[0], this.getEndPos()[1], this.getEndPos()[2], 0.0, 0.0, 0.0, ((TubeData)this.getData()).makeEffect(this).setHideTicks(segment, true).setStartPos(this.getEndPos()[0], this.getEndPos()[1], this.getEndPos()[2]).setEndPos(0.0f, 0.0f, 0.0f).setLifetimeTicks(RandomHelper.getRandomNumberBetween(0, 360))));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onConstruct(AttackEffect effect) {
        effect.mX = 0.0;
        effect.mY = 0.0;
        effect.mZ = 0.0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInit(ParticleArcanery particle, AttackEffect effect) {
        particle.setMotion(0.0, 0.0, 0.0);
        effect.mX = 0.0;
        effect.mY = 0.0;
        effect.mZ = 0.0;
    }

    public float ticksVisible(AttackEffect effect) {
        return effect.ticker - effect.hiddenUntil;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onEnable(ParticleArcanery particle, AttackEffect effect) {
        effect.mX = 0.0;
        effect.mY = 0.0;
        effect.mZ = 0.0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdate(ParticleArcanery particle, AttackEffect effect) {
        float ticksVisible = this.ticksVisible(effect);
        if (ticksVisible <= 0.0f) {
            return;
        }
        float height = this.getStartPos()[1] + ticksVisible * ((TubeData)this.getData()).getSpeed() / 20.0f * 2.0f;
        if (height + 1.0f > this.getStartPos()[1] + ((TubeData)this.getData()).height) {
            particle.setRGBA(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF() * 0.9f);
            if (height > this.getStartPos()[1] + ((TubeData)this.getData()).height) {
                particle.func_187112_i();
                return;
            }
        }
        float radius = ((TubeData)this.getData()).radius;
        if (((TubeData)this.getData()).conical) {
            radius = Math.min(((TubeData)this.getData()).radius, ((TubeData)this.getData()).apexRadius + ticksVisible * ((TubeData)this.getData()).getSpeed() / 20.0f / ((TubeData)this.getData()).narrowness);
        }
        float theta = (ticksVisible * ((TubeData)this.getData()).getSpeed() * 18.0f + 360.0f * (1.0f * (float)effect.maxAge / (float)((TubeData)this.getData()).getPower() + 1.0f * (float)effect.hiddenUntil / (float)((TubeData)this.getData()).segments)) % 360.0f;
        float x = this.getEndPos()[0] + radius * (float)Math.cos(Math.PI / 180 * (double)theta);
        float y = height;
        float z = this.getEndPos()[2] + radius * (float)Math.sin(Math.PI / 180 * (double)theta);
        particle.func_187109_b(x, y, z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdateEol(ParticleArcanery particle, AttackEffect effect) {
        particle.setRGBA(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF() * 0.95f);
    }

    public static class TubeData
    extends StandardParticleAnimationData {
        private int segments = 13;
        private float height = 2.0f;
        private float radius = 2.0f;
        private boolean conical = true;
        private float narrowness = 1.0f;
        private float apexRadius = 0.75f;

        @Override
        public void writeToByteBuffer(ByteBuf buf) {
            super.writeToByteBuffer(buf);
            buf.writeBoolean(this.segments != 13);
            if (this.segments != 13) {
                buf.writeByte(this.segments);
            }
            buf.writeBoolean(this.height != 2.0f);
            if (this.height != 2.0f) {
                buf.writeFloat(this.height);
            }
            buf.writeBoolean(this.radius != 1.0f);
            if (this.radius != 1.0f) {
                buf.writeFloat(this.radius);
            }
            buf.writeBoolean(this.conical);
            if (this.conical) {
                buf.writeBoolean(this.narrowness != 1.0f);
                if (this.narrowness != 1.0f) {
                    buf.writeFloat(this.narrowness);
                }
                buf.writeBoolean(this.apexRadius != 0.0f);
                if (this.apexRadius != 0.0f) {
                    buf.writeFloat(this.apexRadius);
                }
            }
        }

        @Override
        public StandardParticleAnimationData readFromByteBuffer(ByteBuf buf) {
            super.readFromByteBuffer(buf);
            if (buf.readBoolean()) {
                this.segments = buf.readByte();
            }
            if (buf.readBoolean()) {
                this.height = buf.readFloat();
            }
            if (buf.readBoolean()) {
                this.radius = buf.readFloat();
            }
            this.conical = buf.readBoolean();
            if (this.conical) {
                if (buf.readBoolean()) {
                    this.narrowness = buf.readFloat();
                }
                if (buf.readBoolean()) {
                    this.apexRadius = buf.readFloat();
                }
            }
            return this;
        }

        @Override
        public void initFromAttack(ImmutableAttack attack, int effectivePower, Element effectiveType) {
            if (this.getSpeed() == -1.0f) {
                this.setSpeed((float)(1.0 + (RandomHelper.getRandom().nextDouble() - 0.5) / 5.0));
            }
            if (this.getPower() == -1) {
                this.setPower(6);
            }
            super.initFromAttack(attack, effectivePower, effectiveType);
        }

        @Override
        public EffectType getEffectEnum() {
            return EffectType.TUBE;
        }

        public TubeData setSegments(int segments) {
            this.segments = segments;
            return this;
        }

        public TubeData setHeight(float height) {
            this.height = height;
            return this;
        }

        public TubeData setRadius(float radius) {
            this.radius = radius;
            return this;
        }

        public TubeData setConical(boolean conical) {
            this.conical = conical;
            return this;
        }

        public TubeData setNarrowness(float narrowness) {
            this.narrowness = narrowness;
            return this;
        }

        public TubeData setApexRadius(float apexRadius) {
            this.apexRadius = apexRadius;
            return this;
        }

        public int getSegments() {
            return this.segments;
        }

        public float getHeight() {
            return this.height;
        }

        public float getRadius() {
            return this.radius;
        }

        public boolean isConical() {
            return this.conical;
        }

        public float getNarrowness() {
            return this.narrowness;
        }

        public float getApexRadius() {
            return this.apexRadius;
        }
    }
}

