/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.attackAnimations.AttackAnimation;
import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.MoveFlags;
import com.pixelmonmod.pixelmon.battles.attacks.TargetingInfo;
import com.pixelmonmod.pixelmon.battles.attacks.ZMove;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class ImmutableAttack
implements ITranslatable {
    private final int attackIndex;
    private final String attackName;
    private final Element attackType;
    private final AttackCategory attackCategory;
    private final int basePower;
    private int ppBase;
    private int ppMax;
    private int accuracy;
    private boolean makesContact;
    private boolean ignoreAbility = false;
    private TargetingInfo targetingInfo;
    private MoveFlags flags;
    public List<EffectBase> effects = Lists.newArrayList();
    public List<AttackAnimation> animations = Lists.newArrayList();
    public List<ZMove> z = Lists.newArrayList();
    private Set<String> tags = Sets.newHashSet();
    private transient String json;
    private transient ResourceLocation resourceLocation;

    public ImmutableAttack(Element attackType, int basePower, AttackCategory attackCategory) {
        this.attackIndex = -1;
        this.attackType = attackType;
        this.basePower = basePower;
        this.attackCategory = attackCategory;
        this.attackName = "";
    }

    public Attack ofMutable() {
        return new Attack(this);
    }

    @Deprecated
    public int getAttackIndex() {
        return this.attackIndex;
    }

    public String getAttackName() {
        return this.attackName;
    }

    public Element getAttackType() {
        return this.attackType;
    }

    public AttackCategory getAttackCategory() {
        return this.attackCategory;
    }

    public int getBasePower() {
        return this.basePower;
    }

    public int getPPBase() {
        return this.ppBase;
    }

    public int getPPMax() {
        return this.ppMax;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public boolean getMakesContact() {
        return this.makesContact;
    }

    public void setMakesContact(boolean makesContact) {
        this.makesContact = makesContact;
    }

    public boolean getIgnoresAbilities() {
        return this.ignoreAbility;
    }

    public TargetingInfo getTargetingInfo() {
        return this.targetingInfo;
    }

    public MoveFlags getFlags() {
        return this.flags == null ? MoveFlags.DEFAULT : this.flags;
    }

    public boolean isAttack(Optional<ImmutableAttack> attack) {
        return attack.isPresent() && Objects.equals(attack.get(), this);
    }

    public boolean isAttack(ImmutableAttack attack) {
        return Objects.equals(attack, this);
    }

    public int getPriority(PixelmonWrapper pixelmon) {
        int priority = 0;
        for (EffectBase effect : this.effects) {
            if (effect == null) continue;
            priority = effect.modifyPriority(priority, this, pixelmon);
        }
        return priority;
    }

    public boolean hasSecondaryEffect() {
        for (EffectBase effect : this.effects) {
            if (!effect.isChance()) continue;
            return true;
        }
        return false;
    }

    public <T extends EffectBase> boolean hasEffect(Class<T> clazz) {
        if (this.effects != null) {
            for (EffectBase effect : this.effects) {
                if (!clazz.isInstance(effect)) continue;
                return true;
            }
        }
        return false;
    }

    public ZMove getZMove(Pokemon pokemon, boolean bypassItemRequirement) {
        if (this.z != null) {
            for (ZMove zMove : this.z) {
                String itemName = pokemon.getHeldItemAsItemHeld().func_77658_a();
                String paraName = "item.pixelmon." + zMove.crystal;
                if (!bypassItemRequirement && !itemName.equalsIgnoreCase(paraName)) continue;
                if (zMove.allowedPokemon.isEmpty()) {
                    return zMove;
                }
                for (String zMoveSpecString : zMove.allowedPokemon) {
                    PokemonSpecification zMoveSpec = PokemonSpecificationProxy.create(zMoveSpecString);
                    if (!zMoveSpec.matches(pokemon)) continue;
                    return zMove;
                }
            }
        }
        return null;
    }

    public ZMove getZMove(PixelmonClientData pig, boolean bypassItemRequirement) {
        if (this.z != null) {
            for (ZMove zMove : this.z) {
                String itemName = pig.heldItem.toString();
                String paraName = zMove.crystal;
                if (!bypassItemRequirement && !itemName.equalsIgnoreCase(paraName)) continue;
                if (zMove.allowedPokemon.isEmpty()) {
                    return zMove;
                }
                StringBuilder specStringBuilder = new StringBuilder(pig.species.getName());
                if (!pig.form.isEmpty()) {
                    specStringBuilder.append(" form:").append(pig.form);
                }
                if (!pig.palette.isEmpty()) {
                    specStringBuilder.append(" palette:").append(pig.palette);
                }
                if (!pig.getGender().toString().isEmpty()) {
                    specStringBuilder.append(" gender:").append(pig.getGender().toString());
                }
                PokemonSpecification pigSpec = PokemonSpecificationProxy.create(specStringBuilder);
                Pokemon pokemon = pigSpec.create(true);
                for (String zMoveSpecString : zMove.allowedPokemon) {
                    PokemonSpecification zMoveSpec = PokemonSpecificationProxy.create(zMoveSpecString);
                    if (!zMoveSpec.matches(pokemon)) continue;
                    return zMove;
                }
            }
        }
        return null;
    }

    public boolean hasZMove(Pokemon pokemon) {
        if (this.z != null) {
            for (ZMove zMove : this.z) {
                String paraName;
                String itemName;
                if (pokemon == null || !(itemName = pokemon.getHeldItemAsItemHeld().func_77658_a()).equalsIgnoreCase(paraName = "item.pixelmon." + zMove.crystal)) continue;
                if (zMove.allowedPokemon.isEmpty()) {
                    return true;
                }
                for (String zMoveSpecString : zMove.allowedPokemon) {
                    PokemonSpecification zMoveSpec = PokemonSpecificationProxy.create(zMoveSpecString);
                    if (!zMoveSpec.matches(pokemon)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasTag(String ... tags) {
        return this.is(tags);
    }

    public boolean is(String ... tags) {
        if (this.tags == null) {
            return false;
        }
        for (String tag : tags) {
            if (!this.tags.contains(tag)) continue;
            return true;
        }
        return false;
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public void setResourceLocation(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    @Override
    public String getTranslationKey() {
        return "attack." + this.attackName.toLowerCase(Locale.ROOT).replace(" ", "_") + "";
    }

    public String getDescriptionKey() {
        return this.getTranslationKey() + ".description";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableAttack)) {
            return false;
        }
        ImmutableAttack that = (ImmutableAttack)o;
        return this.getAttackName().equals(that.getAttackName());
    }

    public String toString() {
        return "AttackBase{attackName='" + this.attackName + '\'' + '}';
    }

    public int hashCode() {
        return this.getAttackName().hashCode();
    }
}

