/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api.rules.clauses.type;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.ArrayHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.items.HeldItem;

public class AbilityClause
extends BattleClause {
    private final Class<? extends AbstractAbility>[] abilities;

    @SafeVarargs
    public AbilityClause(String id, Class<? extends AbstractAbility> ... abilities) {
        super(id);
        this.abilities = abilities;
    }

    @Override
    public boolean validateSingle(Pokemon pokemon) {
        Species species;
        HeldItem heldItem = pokemon.getHeldItemAsItemHeld();
        if (PixelmonWrapper.canMegaEvolve(heldItem, species = pokemon.getSpecies(), pokemon.getForm().getName())) {
            Class<?> megaAbilityClass;
            Stats form = null;
            form = species != PixelmonSpecies.NECROZMA.getValueUnsafe() ? pokemon.getForm().getMegaForm(heldItem).orElse(pokemon.getForm()) : pokemon.getSpecies().getForm("ultra");
            Ability megaAbility = form.getAbilities().getAll()[0];
            Class<?> clazz = megaAbilityClass = megaAbility == null ? null : megaAbility.getClass();
            if (ArrayHelper.contains(this.abilities, megaAbilityClass)) {
                return false;
            }
        }
        return !pokemon.getAbility().isAbility(this.abilities);
    }
}

