/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.spriteItem.UpdateSpriteItemRequestPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.SpriteItem;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpriteItemHelper {
    public static final String NDEX = "ndex";
    public static final String FORM = "form";
    public static final String GENDER = "gender";
    public static final String PALETTE = "palette";

    public static ItemStack getPhoto(PixelmonEntity pixelmon) {
        return SpriteItemHelper.getPhoto(pixelmon.getPokemon());
    }

    public static ItemStack getPhoto(Pokemon pokemon) {
        ItemStack itemStack = new ItemStack((IItemProvider)PixelmonItems.pixelmon_sprite);
        CompoundNBT tagCompound = new CompoundNBT();
        itemStack.func_77982_d(tagCompound);
        tagCompound.func_74777_a(NDEX, (short)pokemon.getSpecies().getDex());
        tagCompound.func_74778_a(FORM, pokemon.getForm().getName());
        tagCompound.func_74774_a(GENDER, (byte)pokemon.getGender().ordinal());
        tagCompound.func_74778_a(PALETTE, pokemon.getPalette().getName());
        if (pokemon.isEgg()) {
            tagCompound.func_74768_a("eggCycles", pokemon.getEggCycles());
        }
        if (pokemon.getFormattedNickname() != null && !pokemon.getFormattedNickname().getString().isEmpty()) {
            tagCompound.func_74778_a("Nickname", pokemon.getFormattedNickname().getString());
        }
        return itemStack;
    }

    public static ItemStack updateSprite(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof SpriteItem && stack.func_77942_o() && stack.func_77978_p().func_74764_b(NDEX)) {
            PaletteProperties palette;
            Gender gender;
            Species species = PixelmonSpecies.fromNationalDex(Integer.valueOf(stack.func_77978_p().func_74765_d(NDEX)));
            if (species == null) {
                return stack;
            }
            Stats form = species.getForm(stack.func_77978_p().func_74779_i(FORM));
            if (form == null) {
                form = species.getDefaultForm();
                stack.func_77978_p().func_74778_a(FORM, form.getName());
            }
            if ((gender = Gender.values()[stack.func_77978_p().func_74771_c(GENDER)]) == null) {
                gender = form.getDefaultGender();
                stack.func_77978_p().func_74774_a(GENDER, (byte)gender.ordinal());
            }
            if ((palette = form.getGenderProperties(gender).getPalette(stack.func_77978_p().func_74779_i(PALETTE))) == null) {
                palette = form.getGenderProperties(gender).getDefaultPalette();
                stack.func_77978_p().func_74778_a(PALETTE, palette.getName());
            }
        }
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void requestUpdate(ItemStack stack) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            int position = player.field_71071_by.func_184429_b(stack);
            if (position == -1) {
                if (player.field_71071_by.field_70460_b.contains((Object)stack)) {
                    for (int i = 0; i < 4; ++i) {
                        if (!((ItemStack)player.field_71071_by.field_70460_b.get(i)).equals(stack)) continue;
                        position = 36 + i;
                    }
                } else if (player.func_184592_cb().equals(stack)) {
                    position = 40;
                }
            }
            if (position != -1) {
                NetworkHelper.sendToServer(new UpdateSpriteItemRequestPacket(position));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<Pokemon> getPokemon(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return Optional.empty();
        }
        boolean isEgg = stack.func_77978_p().func_74764_b("eggCycles");
        int eggCycles = isEgg ? stack.func_77978_p().func_74762_e("eggCycles") : -1;
        Species species = PixelmonSpecies.fromNationalDex(Integer.valueOf(stack.func_77978_p().func_74765_d(NDEX)));
        if (species == null) {
            return Optional.empty();
        }
        Stats form = species.getForm(stack.func_77978_p().func_74779_i(FORM));
        Gender gender = Gender.values()[stack.func_77978_p().func_74771_c(GENDER)];
        if (form == null || gender == null) {
            SpriteItemHelper.requestUpdate(stack);
            return Optional.empty();
        }
        PaletteProperties palette = form.getGenderProperties(gender).getPalette(stack.func_77978_p().func_74779_i(PALETTE));
        if (palette == null) {
            SpriteItemHelper.requestUpdate(stack);
            return Optional.empty();
        }
        PokemonBase base = new PokemonBase(species, form, palette, gender);
        if (isEgg) {
            base.setEggCycles(eggCycles);
        }
        return Optional.of(base.toPokemon());
    }
}

