/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import java.text.DecimalFormat;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberHelper {
    private static final DecimalFormat FORMATTER = new DecimalFormat("#0.##");
    private static final Pattern INT_PATTERN = Pattern.compile("^[-+]?\\d+$");
    private static final Pattern LONG_PATTERN = Pattern.compile("^[-+]?\\d+$\n");
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("^[-+]?\\d+(\\.\\d+)?$");

    @Deprecated
    public static Optional<Integer> parseInteger(String arg) {
        if (arg == null) {
            return Optional.empty();
        }
        Matcher matcher = INT_PATTERN.matcher(arg);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        return Optional.of(Integer.parseInt(arg));
    }

    public static OptionalInt parseInt(String arg) {
        if (arg == null) {
            return OptionalInt.empty();
        }
        Matcher matcher = INT_PATTERN.matcher(arg);
        if (!matcher.matches()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(Integer.parseInt(arg));
    }

    public static OptionalLong parseLong(String arg) {
        if (arg == null) {
            return OptionalLong.empty();
        }
        Matcher matcher = LONG_PATTERN.matcher(arg);
        if (!matcher.matches()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(Long.parseLong(arg));
    }

    public static OptionalDouble parseDouble(String arg) {
        if (arg == null) {
            return OptionalDouble.empty();
        }
        Matcher matcher = DOUBLE_PATTERN.matcher(arg);
        if (!matcher.matches()) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(Double.parseDouble(arg));
    }

    public static String formatPercentage(double d) {
        return FORMATTER.format(d) + "%";
    }
}

