/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.world.dimension.drowned.DrownedWorld;
import java.util.Optional;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class DimensionHelper {
    public static void teleport(ServerPlayerEntity entity, String dimension, double x, double y, double z) {
        DimensionHelper.teleport(entity, dimension, x, y, z, entity.field_70177_z, entity.field_70125_A);
    }

    public static void teleport(ServerPlayerEntity entity, String dimension, double x, double y, double z, float yaw, float pitch) {
        entity.func_213293_j(0.0, 0.0, 0.0);
        entity.field_70143_R = 0.0f;
        entity.field_71135_a.func_147364_a(x, y, z, entity.field_70177_z, entity.field_70125_A);
        RegistryKey<World> destination = DimensionHelper.getDimension(dimension);
        if (entity.field_70170_p.func_234923_W_() != destination && entity.func_184102_h() != null) {
            DimensionHelper.getWorld(destination).ifPresent(world -> {
                if (destination == DrownedWorld.WORLD) {
                    entity.getPersistentData().func_74780_a("PortalX", entity.func_226277_ct_());
                    entity.getPersistentData().func_74780_a("PortalY", entity.func_226278_cu_());
                    entity.getPersistentData().func_74780_a("PortalZ", entity.func_226281_cx_());
                    entity.getPersistentData().func_74778_a("PortalD", entity.func_71121_q().func_234923_W_().func_240901_a_().toString());
                }
                int[] coords = DimensionHelper.findSafeTeleportLocation(entity.func_71121_q(), x, y, z);
                entity.func_200619_a(world, (double)coords[0], (double)coords[1], (double)coords[2], yaw, pitch);
                world.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_187812_eh, SoundCategory.MASTER, 0.5f, 1.0f);
            });
        }
    }

    public static BlockPos findPosition(ServerWorld level, BlockPos pos, Direction.Axis axis) {
        Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = level.func_175723_af();
        int i = level.func_234938_ad_() - 1;
        BlockPos.Mutable blockpos$mutable = pos.func_239590_i_();
        for (BlockPos.Mutable blockpos$mutable1 : BlockPos.func_243514_a((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(i, level.func_201676_a(Heightmap.Type.MOTION_BLOCKING, blockpos$mutable1.func_177958_n(), blockpos$mutable1.func_177952_p()));
            boolean k = true;
            if (!worldborder.func_177746_a((BlockPos)blockpos$mutable1) || !worldborder.func_177746_a((BlockPos)blockpos$mutable1.func_189534_c(direction, 1))) continue;
            blockpos$mutable1.func_189534_c(direction.func_176734_d(), 1);
            for (int l = j; l >= 0; --l) {
                int j1;
                blockpos$mutable1.func_185336_p(l);
                if (!level.func_175623_d((BlockPos)blockpos$mutable1)) continue;
                int i1 = l;
                while (l > 0 && level.func_175623_d((BlockPos)blockpos$mutable1.func_189536_c(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                blockpos$mutable1.func_185336_p(l);
                double d2 = pos.func_177951_i((Vector3i)blockpos$mutable1);
                if (d0 == -1.0 || d0 > d2) {
                    d0 = d2;
                    blockpos = blockpos$mutable1.func_185334_h();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = blockpos$mutable1.func_185334_h();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            blockpos = new BlockPos(pos.func_177958_n(), MathHelper.func_76125_a((int)pos.func_177956_o(), (int)70, (int)(level.func_234938_ad_() - 10)), pos.func_177952_p()).func_185334_h();
            Direction direction1 = direction.func_176746_e();
            for (int l1 = -1; l1 < 2; ++l1) {
                for (int k2 = 0; k2 < 2; ++k2) {
                    for (int i3 = -1; i3 < 3; ++i3) {
                        blockpos$mutable.func_239621_a_((Vector3i)blockpos, k2 * direction.func_82601_c() + l1 * direction1.func_82601_c(), i3, k2 * direction.func_82599_e() + l1 * direction1.func_82599_e());
                    }
                }
            }
        }
        for (int k1 = -1; k1 < 3; ++k1) {
            for (int i2 = -1; i2 < 4; ++i2) {
                if (k1 != -1 && k1 != 2 && i2 != -1 && i2 != 3) continue;
                blockpos$mutable.func_239621_a_((Vector3i)blockpos, k1 * direction.func_82601_c(), i2, k1 * direction.func_82599_e());
            }
        }
        for (int j2 = 0; j2 < 2; ++j2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                blockpos$mutable.func_239621_a_((Vector3i)blockpos, j2 * direction.func_82601_c(), l2, j2 * direction.func_82599_e());
            }
        }
        return blockpos.func_185334_h();
    }

    public static BlockPos findLocation(ServerWorld world, ServerPlayerEntity player, double x, double y, double z) {
        WorldBorder worldborder = world.func_175723_af();
        double d0 = Math.max(-2.9999872E7, worldborder.func_177726_b() + 16.0);
        double d1 = Math.max(-2.9999872E7, worldborder.func_177736_c() + 16.0);
        double d2 = Math.min(2.9999872E7, worldborder.func_177728_d() - 16.0);
        double d3 = Math.min(2.9999872E7, worldborder.func_177733_e() - 16.0);
        BlockPos blockpos1 = new BlockPos(MathHelper.func_151237_a((double)x, (double)d0, (double)d2), y, MathHelper.func_151237_a((double)z, (double)d1, (double)d3));
        return DimensionHelper.findPosition(world, blockpos1, Direction.Axis.X);
    }

    public static int[] findSafeTeleportLocation(ServerWorld world, double x, double y, double z) {
        return new int[]{(int)x, world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (int)x, (int)z), (int)z};
    }

    public static RegistryKey<World> getDimension(String dimension) {
        if (dimension.isEmpty()) {
            return null;
        }
        return DimensionHelper.getDimension(ResourceLocationHelper.of(dimension));
    }

    public static RegistryKey<World> getDimension(ResourceLocation key) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)key);
    }

    public static Optional<ServerWorld> getWorld(RegistryKey<World> key) {
        return Optional.ofNullable(ServerLifecycleHooks.getCurrentServer().func_71218_a(key));
    }

    public static Optional<ServerWorld> getWorld(String key) {
        return DimensionHelper.getWorld(DimensionHelper.getDimension(key));
    }
}

