/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraftforge.common.util.BlockSnapshot;

public class NBTTools {
    public static final Gson gson = new GsonBuilder().create();

    public static String serializeBlockSnapshot(BlockSnapshot snapshot) {
        CompoundNBT nbt = snapshot.getNbt();
        return gson.toJson(NBTTools.nbtToMap(nbt));
    }

    public static Map<String, Object> nbtToMap(CompoundNBT nbt) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : nbt.func_150296_c()) {
            try {
                INBT base = nbt.func_74781_a(key);
                if (base instanceof StringNBT) {
                    map.put(key, ((StringNBT)base).func_150285_a_());
                    continue;
                }
                if (base instanceof NumberNBT) {
                    map.put(key, ((NumberNBT)base).func_150286_g());
                    continue;
                }
                if (!(base instanceof CompoundNBT)) continue;
                map.put(key, NBTTools.nbtToMap((CompoundNBT)base));
            }
            catch (Exception exception) {}
        }
        return map;
    }

    public static CompoundNBT nbtFromMap(Map<String, Object> map) {
        CompoundNBT nbt = new CompoundNBT();
        for (String key : map.keySet()) {
            try {
                if (map.get(key) instanceof List) {
                    List list = (List)map.get(key);
                    ListNBT tagList = new ListNBT();
                    for (int i = 0; i < list.size(); ++i) {
                        tagList.add((Object)StringNBT.func_229705_a_((String)((String)list.get(i))));
                    }
                    nbt.func_218657_a(key, (INBT)tagList);
                }
                if (map.get(key) instanceof String) {
                    nbt.func_74778_a(key, (String)map.get(key));
                    continue;
                }
                if (map.get(key) instanceof Map) {
                    nbt.func_218657_a(key, (INBT)NBTTools.nbtFromMap((Map)map.get(key)));
                    continue;
                }
                Double d = (Double)map.get(key);
                if ((double)Math.round(d) == d) {
                    nbt.func_74768_a(key, (int)Math.round(d));
                    continue;
                }
                nbt.func_74780_a(key, d.doubleValue());
            }
            catch (Exception exception) {}
        }
        return nbt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompoundNBT loadNBT(File file) throws IOException {
        FileInputStream in = null;
        CompoundNBT result = null;
        try {
            in = new FileInputStream(file);
            result = CompressedStreamTools.func_74796_a((InputStream)in);
        }
        catch (IOException e) {
            try {
                result = CompressedStreamTools.func_74797_a((File)file);
            }
            finally {
                in.close();
            }
        }
        return result;
    }

    public static void saveNBT(CompoundNBT nbt, File file, boolean compressed) throws IOException {
        file.getParentFile().mkdirs();
        file.createNewFile();
        NBTTools.saveNBT(nbt, new FileOutputStream(file), compressed);
    }

    public static void saveNBT(CompoundNBT nbt, OutputStream out, boolean compressed) throws IOException {
        if (compressed) {
            CompressedStreamTools.func_74799_a((CompoundNBT)nbt, (OutputStream)out);
        } else {
            CompressedStreamTools.func_74800_a((CompoundNBT)nbt, (DataOutput)new DataOutputStream(out));
        }
    }
}

