/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.notexamples;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.battles.BattleTickEvent;
import com.pixelmonmod.pixelmon.api.events.battles.TurnEndEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.api.test.UnitTest;
import com.pixelmonmod.pixelmon.battles.api.BattleBuilder;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.BattlePriorityHelper;
import com.pixelmonmod.pixelmon.battles.controller.ai.NoOpAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ShellTrapTest {
    private ShellTrapTest() {
        throw new UnsupportedOperationException("Unit test");
    }

    @UnitTest(value="shell_trap_damages_opponents_not_user")
    public static CompletableFuture<TestResult> testShellTrap() {
        Attack rage = AttackRegistry.RAGE.get().ofMutable();
        Attack shellTrap = AttackRegistry.SHELL_TRAP.get().ofMutable();
        WildPixelmonParticipant magikarpOne = ShellTrapTest.createMagikarp();
        WildPixelmonParticipant magikarpTwo = ShellTrapTest.createMagikarp();
        WildPixelmonParticipant magikarpThree = ShellTrapTest.createMagikarp();
        return ((CompletableFuture)BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.DOUBLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Both)).teamOne(magikarpOne).teamTwo(magikarpTwo, magikarpThree).start().thenCompose(controller -> {
            magikarpOne.asWrapper().setAttack(shellTrap, (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{magikarpTwo.asWrapper(), magikarpThree.asWrapper()}), false);
            magikarpTwo.asWrapper().setAttack(rage, (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{magikarpOne.asWrapper()}), false);
            magikarpThree.asWrapper().setAttack(rage, (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{magikarpOne.asWrapper()}), false);
            BattlePriorityHelper.checkMoveSpeed(magikarpOne.asWrapper().bc);
            for (int i = 0; i < 3; ++i) {
                List<PixelmonWrapper> turnList = magikarpOne.asWrapper().bc.turnList;
                if (i >= turnList.size()) continue;
                turnList.get(i).takeTurn();
            }
            controller.addTaskAtEvent(BattleTickEvent.Pre.class, (pre, bc) -> controller.endTurn());
            return controller.addFunctionAtEvent(TurnEndEvent.class, (turnEndEvent, bc) -> bc);
        })).thenApply(controller -> {
            if ((double)magikarpTwo.asWrapper().pokemon.getHealthPercentage() == 100.0 || (double)magikarpThree.asWrapper().pokemon.getHealthPercentage() == 100.0) {
                return TestResult.failure("The Shell Trap did not activate.");
            }
            return TestResult.success();
        });
    }

    private static WildPixelmonParticipant createMagikarp() {
        WildPixelmonParticipant participant = new WildPixelmonParticipant(PokemonBuilder.builder().species(PixelmonSpecies.MAGIKARP.getValue()).heldItem(PixelmonItems.focus_sash).build());
        participant.setBattleAI(new NoOpAI(participant));
        return participant;
    }
}

