/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.notexamples;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.battles.BattleTickEvent;
import com.pixelmonmod.pixelmon.api.events.battles.TurnEndEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.api.test.UnitTest;
import com.pixelmonmod.pixelmon.battles.api.BattleBuilder;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.NoOpAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ClangorousSoulblazeCorrectBoostAmountTest {
    private ClangorousSoulblazeCorrectBoostAmountTest() {
        throw new UnsupportedOperationException("Unit test");
    }

    @UnitTest(value="clangorous_soulblaze_correct_boost_amount")
    public static CompletableFuture<TestResult> testClangorousSoulblazeCorrectBoostAmount() {
        Attack clangorousSoublaze = AttackRegistry.CLANGOROUS_SOULBLAZE.get().ofMutable();
        Attack splash = AttackRegistry.SPLASH.get().ofMutable();
        WildPixelmonParticipant magikarpOne = ClangorousSoulblazeCorrectBoostAmountTest.createMagikarp();
        WildPixelmonParticipant magikarpTwo = ClangorousSoulblazeCorrectBoostAmountTest.createMagikarp();
        WildPixelmonParticipant kommoO = ClangorousSoulblazeCorrectBoostAmountTest.createKommoO();
        return ((CompletableFuture)BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.SINGLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Both)).teamOne(magikarpOne, magikarpTwo).teamTwo(kommoO).start().thenCompose(controller -> {
            kommoO.asWrapper().setAttack(clangorousSoublaze, (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{magikarpOne.asWrapper(), magikarpTwo.asWrapper()}), false);
            magikarpOne.asWrapper().setAttack(splash, (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{kommoO.asWrapper()}), false);
            magikarpTwo.asWrapper().setAttack(splash, (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{kommoO.asWrapper()}), false);
            kommoO.asWrapper().takeTurn();
            magikarpOne.asWrapper().takeTurn();
            magikarpTwo.asWrapper().takeTurn();
            controller.addTaskAtEvent(BattleTickEvent.Pre.class, (pre, bc) -> controller.endTurn());
            return controller.addFunctionAtEvent(TurnEndEvent.class, (turnEndEvent, bc) -> bc);
        })).thenApply(controller -> {
            int[] stages = kommoO.asWrapper().getBattleStats().getStages();
            for (int i = 2; i < stages.length; ++i) {
                if (stages[i] == 1) continue;
                return TestResult.failure("The Kommo-O achieved an incorrect boost in a double battle instead of just a +1 boost.");
            }
            return TestResult.success();
        });
    }

    private static WildPixelmonParticipant createMagikarp() {
        WildPixelmonParticipant participant = new WildPixelmonParticipant(PokemonBuilder.builder().species(PixelmonSpecies.MAGIKARP.getValue()).build());
        participant.setBattleAI(new NoOpAI(participant));
        return participant;
    }

    private static WildPixelmonParticipant createKommoO() {
        WildPixelmonParticipant participant = new WildPixelmonParticipant(PokemonBuilder.builder().species(PixelmonSpecies.KOMMOO.getValue()).build());
        participant.setBattleAI(new NoOpAI(participant));
        return participant;
    }
}

