/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageSaveAdapter;
import com.pixelmonmod.pixelmon.api.storage.StorageSaveScheduler;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.PCTileEntity;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc.ClientInitializePCPacket;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;

public interface StorageManager {
    public StorageSaveScheduler getSaveScheduler();

    public StorageSaveAdapter getSaveAdapter();

    public PCStorage getPCForPlayer(UUID var1);

    public PlayerPartyStorage getParty(UUID var1);

    public Iterable<PokemonStorage> getAllCachedStorages();

    public void onStorageSaved(PokemonStorage var1);

    public void clearAll();

    default public PCStorage getPC(ServerPlayerEntity player, PCTileEntity pc) {
        return this.getPCForPlayer(player);
    }

    default public PCStorage getPCForPlayer(ServerPlayerEntity player) {
        return this.getPCForPlayer(player.func_110124_au());
    }

    default public PlayerPartyStorage getParty(ServerPlayerEntity player) {
        return this.getParty(player.func_110124_au());
    }

    default public PokemonStorage getStorage(ServerPlayerEntity player, StoragePosition position) {
        if (position.box == -1) {
            return this.getParty(player);
        }
        return this.getPCForPlayer(player);
    }

    default public Pokemon getPokemon(ServerPlayerEntity player, StoragePosition position) {
        if (position.box == -1) {
            return this.getParty(player).get(position);
        }
        return this.getPCForPlayer(player).get(position);
    }

    default public void initializePCForPlayer(ServerPlayerEntity player, PCStorage pc) {
        NetworkHelper.sendPacket(player, new ClientInitializePCPacket(pc));
        pc.sendContents(player);
    }
}

